/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.StartState;
import org.sonarsource.analyzer.commons.regex.helpers.RegexReachabilityChecker;
import org.sonarsource.analyzer.commons.regex.helpers.RegexTreeHelper;

public class ReluctantQuantifierWithEmptyContinuationFinder
extends RegexBaseVisitor {
    private static final String MESSAGE_FIX = "Fix this reluctant quantifier that will only ever match %s repetition%s.";
    private static final String MESSAGE_UNNECESSARY = "Remove the '?' from this unnecessarily reluctant quantifier.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private AutomatonState endState;

    public ReluctantQuantifierWithEmptyContinuationFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    protected void before(RegexParseResult regexParseResult) {
        this.endState = regexParseResult.getFinalState();
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        super.visitRepetition(tree);
        if (tree.getQuantifier().getModifier() == Quantifier.Modifier.RELUCTANT) {
            if (RegexTreeHelper.isAnchoredAtEnd(tree.continuation())) {
                if (RegexTreeHelper.onlyMatchesEmptySuffix(tree.continuation())) {
                    this.regexElementIssueReporter.report(tree, MESSAGE_UNNECESSARY, null, Collections.emptyList());
                }
            } else if (RegexReachabilityChecker.canReachWithoutConsumingInput(new StartState(tree.continuation(), tree.activeFlags()), this.endState)) {
                int minimumRepetitions = tree.getQuantifier().getMinimumRepetitions();
                this.regexElementIssueReporter.report(tree, String.format(MESSAGE_FIX, minimumRepetitions, minimumRepetitions == 1 ? "" : "s"), null, Collections.emptyList());
            }
        }
    }
}

