/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassUnionTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

public class GraphemeInClassFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Extract %d Grapheme Cluster(s) from this character class.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private final List<RegexIssueLocation> graphemeClusters = new ArrayList<RegexIssueLocation>();

    public GraphemeInClassFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitCharacterClass(CharacterClassTree tree) {
        super.visitCharacterClass(tree);
        if (!this.graphemeClusters.isEmpty()) {
            this.regexElementIssueReporter.report(tree, String.format(MESSAGE, this.graphemeClusters.size()), null, this.graphemeClusters);
        }
        this.graphemeClusters.clear();
    }

    @Override
    public void visitCharacterClassUnion(CharacterClassUnionTree tree) {
        this.graphemeClusters.addAll(GraphemeHelper.getGraphemeInList(tree.getCharacterClasses()));
        super.visitCharacterClassUnion(tree);
    }

    private static class GraphemeHelper {
        private static final Pattern MARK_PATTERN = Pattern.compile("\\p{M}");

        private GraphemeHelper() {
        }

        private static List<RegexIssueLocation> getGraphemeInList(List<? extends RegexSyntaxElement> trees) {
            ArrayList<RegexIssueLocation> result = new ArrayList<RegexIssueLocation>();
            ArrayList<RegexSyntaxElement> codePoints = new ArrayList<RegexSyntaxElement>();
            for (RegexSyntaxElement regexSyntaxElement : trees) {
                CharacterTree currentCharacter;
                if (regexSyntaxElement instanceof CharacterTree && !(currentCharacter = (CharacterTree)regexSyntaxElement).isEscapeSequence()) {
                    if (!GraphemeHelper.isMark(currentCharacter)) {
                        GraphemeHelper.addCurrentGrapheme(result, codePoints);
                        codePoints.clear();
                        codePoints.add(currentCharacter);
                        continue;
                    }
                    if (codePoints.isEmpty()) continue;
                    codePoints.add(currentCharacter);
                    continue;
                }
                GraphemeHelper.addCurrentGrapheme(result, codePoints);
                codePoints.clear();
            }
            GraphemeHelper.addCurrentGrapheme(result, codePoints);
            return result;
        }

        private static boolean isMark(CharacterTree currentChar) {
            return MARK_PATTERN.matcher(currentChar.characterAsString()).matches();
        }

        private static void addCurrentGrapheme(List<RegexIssueLocation> result, List<RegexSyntaxElement> codePoints) {
            if (codePoints.size() > 1) {
                result.add(new RegexIssueLocation(codePoints, ""));
            }
        }
    }
}

