/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class AliasedNameImpl
extends PyTree
implements AliasedName {
    private final Token asKeyword;
    private final DottedName dottedName;
    private final Name alias;

    public AliasedNameImpl(Token asKeyword, DottedName dottedName, Name alias) {
        this.asKeyword = asKeyword;
        this.dottedName = dottedName;
        this.alias = alias;
    }

    public AliasedNameImpl(DottedName dottedName) {
        this.asKeyword = null;
        this.dottedName = dottedName;
        this.alias = null;
    }

    @Override
    @CheckForNull
    public Token asKeyword() {
        return this.asKeyword;
    }

    @Override
    @CheckForNull
    public Name alias() {
        return this.alias;
    }

    @Override
    public DottedName dottedName() {
        return this.dottedName;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ALIASED_NAME;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAliasedName(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.dottedName, this.asKeyword, this.alias).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

