/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S2772")
public class NeedlessPassCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this unneeded \"pass\".";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STATEMENT_LIST, ctx -> {
            List statements = ((StatementList)ctx.syntaxNode()).statements().stream().filter(NeedlessPassCheck::isNotStringLiteralExpressionStatement).collect(Collectors.toList());
            if (statements.size() <= 1) {
                return;
            }
            statements.stream().filter(st -> st.is(Tree.Kind.PASS_STMT)).findFirst().ifPresent(st -> ctx.addIssue((Tree)st, MESSAGE));
        });
    }

    private static boolean isNotStringLiteralExpressionStatement(Statement st) {
        return !st.is(Tree.Kind.EXPRESSION_STMT) || !((ExpressionStatement)st).expressions().stream().allMatch(e -> e.is(Tree.Kind.STRING_LITERAL));
    }
}

