/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonPunctuator;

@Rule(key="InequalityUsage")
public class InequalityUsageCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            BinaryExpression expr = (BinaryExpression)ctx.syntaxNode();
            Token operator = expr.operator();
            if (operator.value().equals(PythonPunctuator.NOT_EQU2.getValue())) {
                ctx.addIssue(operator, "Replace \"<>\" by \"!=\".");
            }
        });
    }
}

