/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.ProgramState;

public abstract class ForwardAnalysis {
    protected final Map<CfgBlock, ProgramStateAtBlock> programStateByBlock = new HashMap<CfgBlock, ProgramStateAtBlock>();

    public void compute(ControlFlowGraph cfg) {
        ProgramState initialState = this.initialState();
        Set<CfgBlock> blocks = cfg.blocks();
        blocks.forEach(block -> this.programStateByBlock.put((CfgBlock)block, new ProgramStateAtBlock((CfgBlock)block, initialState)));
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>(blocks);
        while (!workList.isEmpty()) {
            CfgBlock currentBlock = (CfgBlock)workList.pop();
            ProgramStateAtBlock programStateAtBlock = this.programStateByBlock.get(currentBlock);
            boolean outHasChanged = programStateAtBlock.propagate();
            if (!outHasChanged) continue;
            currentBlock.successors().forEach(workList::push);
        }
    }

    public abstract ProgramState initialState();

    public abstract void updateProgramState(Tree var1, ProgramState var2);

    protected class ProgramStateAtBlock {
        private final CfgBlock block;
        protected ProgramState in;
        protected ProgramState out;

        private ProgramStateAtBlock(CfgBlock block, ProgramState initialState) {
            this.out = ForwardAnalysis.this.initialState();
            this.block = block;
            this.in = initialState;
            this.block.elements().forEach(element -> ForwardAnalysis.this.updateProgramState((Tree)element, this.out));
        }

        private boolean propagate() {
            this.block.predecessors().forEach(predecessor -> {
                this.in = this.in.join(ForwardAnalysis.this.programStateByBlock.get((Object)predecessor).out);
            });
            ProgramState newOut = this.in.copy();
            this.block.elements().forEach(element -> ForwardAnalysis.this.updateProgramState((Tree)element, newOut));
            boolean outHasChanged = !newOut.equals(this.out);
            this.out = newOut;
            return outHasChanged;
        }
    }
}

