---
title: C#
key: csharp
---

<!-- static -->
<!-- update_center:csharp -->
<!-- /static -->


## Language-Specific Properties

Discover and update the C#-specific [properties](/analysis/analysis-parameters/) in: <!-- sonarcloud -->Project <!-- /sonarcloud --> **[Administration > General Settings > C#](/#sonarqube-admin#/admin/settings?category=c%23)**.

### Analyze Generated Code

To analyze tool-generated code (e.g. WCF code generated by `SvcUtil.exe`, protobuf code generated by `protoc`, Swagger client code generated by `NSwag`) for a specific C# project, enable the "Analyze generated code" setting inside **Project > Administration > General Settings > C#**. By default, tool-generated code files are skipped from analysis.

The detection of generated code is based on file name, special comments and attributes. The currently recognized values are in [GeneratedCodeRecognizer.cs](https://github.com/SonarSource/sonar-dotnet/blob/master/analyzers/src/SonarAnalyzer.Common/Helpers/GeneratedCodeRecognizer.cs).

## Scanner compatibility

To analyze C# code, you need to use the [SonarScanner for .NET](/analysis/scan/sonarscanner-for-msbuild/) version 4.x or newer.

## Exclusions

Files to be excluded should be set in the project configuration. Excluded files are still going to be analyzed during the compilation and the results will be filtered according to the exclusion settings.

As an alternative, an `.editorconfig` file can be used to disable the analysis for a specific rule on a file or directory. This can solve performance problems on large files.

```
[Path/File.cs]
dotnet_diagnostic.Sxxx.severity = none
```

## Improving Performance  

You can enable parallel processing to speed up analysis and reduce overall build time by setting the following environment variable:
```
SONAR_DOTNET_ENABLE_CONCURRENT_EXECUTION=true
```
If you still have problems [this](https://community.sonarsource.com/t/47279) community thread may help you diagnose the issues.

## Related Pages
* [Excluding External Roslyn Issues](/analysis/external-issues/) (See "Notes on external .NET issues")
* [Test Coverage & Execution](/analysis/coverage/) (Visual Studio Code Coverage, dotCover, OpenCover)
* [SonarScanner for .NET](/analysis/scan/sonarscanner-for-msbuild/)
* [SonarScanner for Azure DevOps](/analysis/scan/sonarscanner-for-azure-devops/)
* [Analysis of product projects vs. test projects](https://github.com/SonarSource/sonar-scanner-msbuild/wiki/Analysis-of-product-projects-vs.-test-projects)
* [Troubleshooting guide for .NET code coverage import](https://community.sonarsource.com/t/37151)
