/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="TableHeaderHasIdOrScopeCheck")
public class TableHeaderHasIdOrScopeCheck
extends AbstractPageCheck {
    private static final String MESSAGE = "Add either an 'id' or a 'scope' attribute to this <th> tag.";
    private final Deque<TableElement> tables = new ArrayDeque<TableElement>();

    @Override
    public void startElement(TagNode node) {
        if (TableHeaderHasIdOrScopeCheck.isTableTag(node)) {
            this.tables.push(new TableElement());
        }
        if (TableHeaderHasIdOrScopeCheck.isTrTag(node)) {
            this.visitTrNode(node);
        }
    }

    private void visitTrNode(TagNode node) {
        List<TagNode> row = node.getChildren();
        if (!this.tables.isEmpty() && !row.isEmpty()) {
            TableElement currentTable = this.tables.peek();
            for (TagNode element : row) {
                if (!TableHeaderHasIdOrScopeCheck.isThTag(element)) continue;
                currentTable.headers.add(element);
            }
            currentTable.firstCol.add(row.get(0));
            if (currentTable.firstRow.isEmpty()) {
                currentTable.firstRow = row;
            }
        } else {
            this.raiseIssueOnTableHeadersWithoutScopeOrId(row);
        }
    }

    @Override
    public void endElement(TagNode node) {
        TableElement currentTable;
        if (TableHeaderHasIdOrScopeCheck.isTableTag(node) && !this.tables.isEmpty() && !(currentTable = this.tables.pop()).isSimpleTable()) {
            this.raiseIssueOnTableHeadersWithoutScopeOrId(currentTable.headers);
        }
    }

    @Override
    public void endDocument() {
        this.tables.clear();
    }

    private static boolean isThTag(TagNode node) {
        return "th".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isTrTag(TagNode node) {
        return "tr".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isTableTag(TagNode node) {
        return "table".equalsIgnoreCase(node.getNodeName());
    }

    private void raiseIssueOnTableHeadersWithoutScopeOrId(Collection<TagNode> row) {
        row.stream().filter(TableHeaderHasIdOrScopeCheck::isHeaderTableWithoutScopeOrId).forEach(th -> this.createViolation((Node)th, MESSAGE));
    }

    private static boolean isHeaderTableWithoutScopeOrId(TagNode child) {
        return TableHeaderHasIdOrScopeCheck.isThTag(child) && !child.hasProperty("id") && !child.hasProperty("scope");
    }

    private static class TableElement {
        List<TagNode> headers = new ArrayList<TagNode>();
        List<TagNode> firstRow = new ArrayList<TagNode>();
        List<TagNode> firstCol = new ArrayList<TagNode>();

        private TableElement() {
        }

        boolean isSimpleTable() {
            return this.headers.equals(this.firstRow) || this.headers.equals(this.firstCol);
        }
    }
}

