/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.coding;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.node.TextNode;

@Rule(key="InternationalizationCheck")
public class InternationalizationCheck
extends AbstractPageCheck {
    private static final String DEFAULT_ATTRIBUTES = "outputLabel.value, outputText.value";
    @RuleProperty(key="attributes", description="Attributes", defaultValue="outputLabel.value, outputText.value")
    public String attributes = "outputLabel.value, outputText.value";
    @RuleProperty(key="ignoredContentRegex", description="Text content matching this expression will be ignored", defaultValue="")
    public String ignoredContentRegex;
    private Pattern ignoredContentPattern = null;
    private AbstractPageCheck.QualifiedAttribute[] attributesArray;

    @Override
    public void startDocument(List<Node> nodes) {
        this.attributesArray = this.parseAttributes(this.attributes);
        if (!StringUtils.isEmpty(this.ignoredContentRegex)) {
            this.ignoredContentPattern = Pattern.compile(this.ignoredContentRegex);
        }
    }

    @Override
    public void characters(TextNode textNode) {
        String textNodeCode = textNode.getCode();
        if (this.isValidText(textNodeCode)) {
            this.createViolation(textNode, "Define this label in the resource bundle.");
        }
    }

    @Override
    public void startElement(TagNode element) {
        for (AbstractPageCheck.QualifiedAttribute attribute : this.attributesArray) {
            if (!this.notValid(element, attribute)) continue;
            return;
        }
    }

    private boolean notValid(TagNode element, AbstractPageCheck.QualifiedAttribute attribute) {
        String value;
        if (element.equalsElementName(attribute.getNodeName()) && (value = element.getAttribute(attribute.getAttributeName())) != null && (value = value.trim()).length() > 0 && this.isValidText(value)) {
            this.createViolation(element, "Define this label in the resource bundle.");
            return true;
        }
        return false;
    }

    private boolean isValidText(String value) {
        return !this.isUnifiedExpression(value) && InternationalizationCheck.hasNoPunctuationOrSpace(value) && !this.isIgnoredByRegex(value);
    }

    private static boolean hasNoPunctuationOrSpace(String value) {
        return value.chars().allMatch(Character::isLetterOrDigit);
    }

    private boolean isIgnoredByRegex(String value) {
        return this.ignoredContentPattern != null && this.ignoredContentPattern.matcher(value).matches();
    }
}

