/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.UnionType;

class RuntimeType
implements InferredType {
    private ClassSymbol typeClass;
    private String builtinFullyQualifiedName;
    private Set<String> typeClassSuperClassesFQN = null;
    private Set<String> typeClassMembersFQN = null;

    RuntimeType(ClassSymbol typeClass) {
        this.typeClass = typeClass;
    }

    RuntimeType(String builtinFullyQualifiedName) {
        this.builtinFullyQualifiedName = builtinFullyQualifiedName;
    }

    @Override
    public boolean isIdentityComparableWith(InferredType other) {
        if (other == AnyType.ANY || other instanceof DeclaredType) {
            return true;
        }
        if (other instanceof UnionType) {
            return other.isIdentityComparableWith(this);
        }
        return this.equals(other);
    }

    @Override
    public boolean canHaveMember(String memberName) {
        return this.getTypeClass().canHaveMember(memberName);
    }

    @Override
    public boolean declaresMember(String memberName) {
        return this.canHaveMember(memberName);
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        return this.getTypeClass().resolveMember(memberName);
    }

    @Override
    public Optional<Symbol> resolveDeclaredMember(String memberName) {
        return this.resolveMember(memberName);
    }

    @Override
    public boolean canOnlyBe(String typeName) {
        return typeName.equals(this.getTypeClass().fullyQualifiedName());
    }

    @Override
    public boolean canBeOrExtend(String typeName) {
        return this.getTypeClass().canBeOrExtend(typeName);
    }

    @Override
    public boolean isCompatibleWith(InferredType other) {
        return InferredTypes.isTypeClassCompatibleWith(this.getTypeClass(), other);
    }

    @Override
    public boolean mustBeOrExtend(String fullyQualifiedName) {
        return this.getTypeClass().isOrExtends(fullyQualifiedName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeType that = (RuntimeType)o;
        return Objects.equals(this.getTypeClass().name(), that.getTypeClass().name()) && Objects.equals(this.getTypeClass().fullyQualifiedName(), that.getTypeClass().fullyQualifiedName()) && Objects.equals(this.typeClassSuperClassesFQN(), that.typeClassSuperClassesFQN()) && Objects.equals(this.typeClassMembersFQN(), that.typeClassMembersFQN());
    }

    private Set<String> typeClassSuperClassesFQN() {
        if (this.typeClassSuperClassesFQN == null) {
            this.typeClassSuperClassesFQN = this.getTypeClass().superClasses().stream().map(Symbol::fullyQualifiedName).collect(Collectors.toSet());
        }
        return this.typeClassSuperClassesFQN;
    }

    private Set<String> typeClassMembersFQN() {
        if (this.typeClassMembersFQN == null) {
            this.typeClassMembersFQN = this.getTypeClass().declaredMembers().stream().map(Symbol::fullyQualifiedName).collect(Collectors.toSet());
        }
        return this.typeClassMembersFQN;
    }

    boolean hasUnresolvedHierarchy() {
        return ((ClassSymbolImpl)this.getTypeClass()).hasUnresolvedTypeHierarchy(false);
    }

    public int hashCode() {
        return Objects.hash(this.getTypeClass().name(), this.getTypeClass().fullyQualifiedName(), this.typeClassSuperClassesFQN(), this.typeClassMembersFQN());
    }

    public String toString() {
        return "RuntimeType(" + this.getTypeClass().fullyQualifiedName() + ')';
    }

    public ClassSymbol getTypeClass() {
        if (this.typeClass == null) {
            return TypeShed.typeShedClass(this.builtinFullyQualifiedName);
        }
        return this.typeClass;
    }
}

