/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.InferredTypes;

public class TupleImpl
extends PyTree
implements Tuple {
    private final Token leftParenthesis;
    private final List<Expression> elements;
    private final List<Token> commas;
    private final Token rightParenthesis;

    public TupleImpl(@Nullable Token leftParenthesis, List<Expression> elements, List<Token> commas, @Nullable Token rightParenthesis) {
        this.leftParenthesis = leftParenthesis;
        this.elements = elements;
        this.commas = commas;
        this.rightParenthesis = rightParenthesis;
    }

    @Override
    @CheckForNull
    public Token leftParenthesis() {
        return this.leftParenthesis;
    }

    @Override
    public List<Expression> elements() {
        return this.elements;
    }

    @Override
    public List<Token> commas() {
        return this.commas;
    }

    @Override
    @CheckForNull
    public Token rightParenthesis() {
        return this.rightParenthesis;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTuple(this);
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (this.leftParenthesis != null) {
            children.add(this.leftParenthesis);
        }
        int i = 0;
        for (Tree tree : this.elements) {
            children.add(tree);
            if (i < this.commas.size()) {
                children.add(this.commas.get(i));
            }
            ++i;
        }
        if (this.rightParenthesis != null) {
            children.add(this.rightParenthesis);
        }
        return children;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TUPLE;
    }

    @Override
    public InferredType type() {
        return InferredTypes.TUPLE;
    }
}

