/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.tree.PyTree;

public class FunctionDefImpl
extends PyTree
implements FunctionDef {
    private final List<Decorator> decorators;
    private final Token asyncKeyword;
    private final Token defKeyword;
    private final Name name;
    private final Token leftPar;
    private final ParameterList parameters;
    private final Token rightPar;
    private final TypeAnnotation returnType;
    private final Token colon;
    private final Token newLine;
    private final Token indent;
    private final StatementList body;
    private final Token dedent;
    private final boolean isMethodDefinition;
    private final StringLiteral docstring;
    private Set<Symbol> symbols = new HashSet<Symbol>();
    private FunctionSymbol functionSymbol;

    public FunctionDefImpl(List<Decorator> decorators, @Nullable Token asyncKeyword, Token defKeyword, Name name, Token leftPar, @Nullable ParameterList parameters, Token rightPar, @Nullable TypeAnnotation returnType, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList body, @Nullable Token dedent, boolean isMethodDefinition, @Nullable StringLiteral docstring) {
        this.decorators = decorators;
        this.asyncKeyword = asyncKeyword;
        this.defKeyword = defKeyword;
        this.name = name;
        this.leftPar = leftPar;
        this.parameters = parameters;
        this.rightPar = rightPar;
        this.returnType = returnType;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.body = body;
        this.dedent = dedent;
        this.isMethodDefinition = isMethodDefinition;
        this.docstring = docstring;
    }

    @Override
    public List<Decorator> decorators() {
        return this.decorators;
    }

    @Override
    public Token defKeyword() {
        return this.defKeyword;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    @CheckForNull
    public ParameterList parameters() {
        return this.parameters;
    }

    @Override
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    @CheckForNull
    public TypeAnnotation returnTypeAnnotation() {
        return this.returnType;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    public boolean isMethodDefinition() {
        return this.isMethodDefinition;
    }

    @Override
    @CheckForNull
    public StringLiteral docstring() {
        return this.docstring;
    }

    @Override
    public Set<Symbol> localVariables() {
        return this.symbols;
    }

    public void addLocalVariableSymbol(Symbol symbol) {
        this.symbols.add(symbol);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FUNCDEF;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFunctionDef(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.decorators, Arrays.asList(this.asyncKeyword, this.defKeyword, this.name, this.leftPar, this.parameters, this.rightPar, this.returnType, this.colon, this.newLine, this.indent, this.body, this.dedent)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setFunctionSymbol(FunctionSymbol functionSymbol) {
        this.functionSymbol = functionSymbol;
    }

    @CheckForNull
    public FunctionSymbol functionSymbol() {
        return this.functionSymbol;
    }
}

