/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.DescriptorUtils;
import org.sonar.python.index.VariableDescriptor;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

public class ProjectLevelSymbolTable {
    private final Map<String, Set<Descriptor>> globalDescriptorsByModuleName;
    private Map<String, Descriptor> globalDescriptorsByFQN;
    private final Set<String> djangoViewsFQN = new HashSet<String>();

    public static ProjectLevelSymbolTable empty() {
        return new ProjectLevelSymbolTable(Collections.emptyMap());
    }

    public static ProjectLevelSymbolTable from(Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        return new ProjectLevelSymbolTable(globalSymbolsByModuleName);
    }

    public ProjectLevelSymbolTable() {
        this.globalDescriptorsByModuleName = new HashMap<String, Set<Descriptor>>();
    }

    private ProjectLevelSymbolTable(Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        this.globalDescriptorsByModuleName = new HashMap<String, Set<Descriptor>>();
        globalSymbolsByModuleName.entrySet().forEach(entry -> {
            String moduleName = (String)entry.getKey();
            Set symbols = (Set)entry.getValue();
            Set globalDescriptors = symbols.stream().map(DescriptorUtils::descriptor).collect(Collectors.toSet());
            this.globalDescriptorsByModuleName.put(moduleName, globalDescriptors);
        });
    }

    public void removeModule(String packageName, String fileName) {
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, fileName);
        this.globalDescriptorsByModuleName.remove(fullyQualifiedModuleName);
        this.globalDescriptorsByFQN = null;
    }

    public void addModule(FileInput fileInput, String packageName, PythonFile pythonFile) {
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName, pythonFile);
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, pythonFile.fileName());
        fileInput.accept(symbolTableBuilder);
        HashSet<Descriptor> globalDescriptors = new HashSet<Descriptor>();
        for (Symbol globalVariable : fileInput.globalVariables()) {
            String fullyQualifiedVariableName = globalVariable.fullyQualifiedName();
            if (fullyQualifiedVariableName != null && !fullyQualifiedVariableName.startsWith(fullyQualifiedModuleName) || globalVariable.usages().stream().anyMatch(u -> u.kind().equals((Object)Usage.Kind.IMPORT))) continue;
            if (globalVariable.is(Symbol.Kind.CLASS, Symbol.Kind.FUNCTION)) {
                globalDescriptors.add(DescriptorUtils.descriptor(globalVariable));
                continue;
            }
            String fullyQualifiedName = fullyQualifiedModuleName + "." + globalVariable.name();
            if (globalVariable.is(Symbol.Kind.AMBIGUOUS)) {
                globalDescriptors.add(DescriptorUtils.ambiguousDescriptor((AmbiguousSymbol)globalVariable, fullyQualifiedName));
                continue;
            }
            globalDescriptors.add(new VariableDescriptor(globalVariable.name(), fullyQualifiedName, globalVariable.annotatedTypeName()));
        }
        this.globalDescriptorsByModuleName.put(fullyQualifiedModuleName, globalDescriptors);
        if (this.globalDescriptorsByFQN != null) {
            this.addModuleToGlobalSymbolsByFQN(globalDescriptors);
        }
        DjangoViewsVisitor djangoViewsVisitor = new DjangoViewsVisitor();
        fileInput.accept(djangoViewsVisitor);
    }

    private void addModuleToGlobalSymbolsByFQN(Set<Descriptor> descriptors) {
        Map moduleDescriptorsByFQN = descriptors.stream().filter(d -> d.fullyQualifiedName() != null).collect(Collectors.toMap(Descriptor::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousDescriptor.create(xva$0, xva$1)));
        this.globalDescriptorsByFQN.putAll(moduleDescriptorsByFQN);
    }

    private Map<String, Descriptor> globalDescriptorsByFQN() {
        if (this.globalDescriptorsByFQN == null) {
            this.globalDescriptorsByFQN = this.globalDescriptorsByModuleName.values().stream().flatMap(Collection::stream).filter(descriptor -> descriptor.fullyQualifiedName() != null).collect(Collectors.toMap(Descriptor::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousDescriptor.create(xva$0, xva$1)));
        }
        return this.globalDescriptorsByFQN;
    }

    @CheckForNull
    public Symbol getSymbol(@Nullable String fullyQualifiedName) {
        return this.getSymbol(fullyQualifiedName, null);
    }

    public Symbol getSymbol(@Nullable String fullyQualifiedName, @Nullable String localSymbolName) {
        return this.getSymbol(fullyQualifiedName, localSymbolName, new HashMap<Descriptor, Symbol>(), new HashMap<String, Symbol>());
    }

    public Symbol getSymbol(@Nullable String fullyQualifiedName, @Nullable String localSymbolName, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        if (fullyQualifiedName == null) {
            return null;
        }
        Descriptor descriptor = this.globalDescriptorsByFQN().get(fullyQualifiedName);
        return descriptor == null ? null : DescriptorUtils.symbolFromDescriptor(descriptor, this, localSymbolName, createdSymbolsByDescriptor, createdSymbolsByFqn);
    }

    @CheckForNull
    public Set<Symbol> getSymbolsFromModule(@Nullable String moduleName) {
        Set<Descriptor> descriptors = this.globalDescriptorsByModuleName.get(moduleName);
        if (descriptors == null) {
            return null;
        }
        HashMap createdSymbolsByDescriptor = new HashMap();
        HashMap createdSymbolsByFqn = new HashMap();
        return descriptors.stream().map(desc -> DescriptorUtils.symbolFromDescriptor(desc, this, null, createdSymbolsByDescriptor, createdSymbolsByFqn)).collect(Collectors.toSet());
    }

    public boolean isDjangoView(@Nullable String fqn) {
        return this.djangoViewsFQN.contains(fqn);
    }

    private class DjangoViewsVisitor
    extends BaseTreeVisitor {
        private DjangoViewsVisitor() {
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            RegularArgument viewArgument;
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol == null) {
                return;
            }
            if ("django.urls.conf.path".equals(calleeSymbol.fullyQualifiedName()) && (viewArgument = TreeUtils.nthArgumentOrKeyword(1, "view", callExpression.arguments())) != null) {
                TreeUtils.getSymbolFromTree(viewArgument.expression()).filter(symbol -> symbol.fullyQualifiedName() != null).ifPresent(symbol -> ProjectLevelSymbolTable.this.djangoViewsFQN.add(symbol.fullyQualifiedName()));
            }
        }
    }
}

