/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove the unused local variable \"%s\".";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> UnusedLocalVariableCheck.checkLocalVars(ctx, ctx.syntaxNode(), ((FunctionDef)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.DICT_COMPREHENSION, ctx -> UnusedLocalVariableCheck.checkLocalVars(ctx, ctx.syntaxNode(), ((DictCompExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.LIST_COMPREHENSION, ctx -> UnusedLocalVariableCheck.checkLocalVars(ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.SET_COMPREHENSION, ctx -> UnusedLocalVariableCheck.checkLocalVars(ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
        context.registerSyntaxNodeConsumer(Tree.Kind.GENERATOR_EXPR, ctx -> UnusedLocalVariableCheck.checkLocalVars(ctx, ctx.syntaxNode(), ((ComprehensionExpression)ctx.syntaxNode()).localVariables()));
    }

    private static void checkLocalVars(SubscriptionContext ctx, Tree functionTree, Set<Symbol> symbols) {
        if (UnusedLocalVariableCheck.isCallingLocalsFunction(functionTree)) {
            return;
        }
        symbols.stream().filter(s -> !"_".equals(s.name())).filter(UnusedLocalVariableCheck::hasOnlyBindingUsages).forEach(symbol -> symbol.usages().stream().filter(usage -> usage.tree().parent() == null || !usage.tree().parent().is(Tree.Kind.PARAMETER)).filter(usage -> !UnusedLocalVariableCheck.isTupleDeclaration(usage.tree())).filter(usage -> usage.kind() != Usage.Kind.FUNC_DECLARATION).filter(usage -> usage.kind() != Usage.Kind.CLASS_DECLARATION).forEach(usage -> ctx.addIssue(usage.tree(), String.format(MESSAGE, symbol.name()))));
    }

    private static boolean hasOnlyBindingUsages(Symbol symbol) {
        List<Usage> usages = symbol.usages();
        if (UnusedLocalVariableCheck.isOnlyTypeAnnotation(usages)) {
            return false;
        }
        return usages.stream().noneMatch(usage -> usage.kind() == Usage.Kind.IMPORT) && usages.stream().allMatch(Usage::isBindingUsage);
    }

    private static boolean isOnlyTypeAnnotation(List<Usage> usages) {
        return usages.size() == 1 && usages.get(0).isBindingUsage() && TreeUtils.firstAncestor(usages.get(0).tree(), t -> t.is(Tree.Kind.ANNOTATED_ASSIGNMENT) && ((AnnotatedAssignment)t).assignedValue() == null) != null;
    }

    private static boolean isTupleDeclaration(Tree tree) {
        return TreeUtils.firstAncestor(tree, t -> t.is(Tree.Kind.TUPLE) || t.is(Tree.Kind.EXPRESSION_LIST) && ((ExpressionList)t).expressions().size() > 1 || t.is(Tree.Kind.FOR_STMT) && ((ForStatement)t).expressions().size() > 1 && ((ForStatement)t).expressions().contains(tree)) != null;
    }

    private static boolean isCallingLocalsFunction(Tree tree) {
        return TreeUtils.hasDescendant(tree, t -> t.is(Tree.Kind.CALL_EXPR) && UnusedLocalVariableCheck.calleeHasNameLocals((CallExpression)t));
    }

    private static boolean calleeHasNameLocals(CallExpression callExpression) {
        Expression callee = callExpression.callee();
        return callee.is(Tree.Kind.NAME) && "locals".equals(((Name)callee).name());
    }
}

