/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.ReadWriteVisitor;

public abstract class CfgBlockState {
    protected final CfgBlock block;
    protected final Map<Tree, Map<Symbol, ReadWriteVisitor.SymbolReadWrite>> variableReadWritesPerElement;
    protected final Set<Symbol> gen = new HashSet<Symbol>();
    protected final Set<Symbol> kill = new HashSet<Symbol>();

    CfgBlockState(CfgBlock block) {
        this.block = block;
        this.variableReadWritesPerElement = new HashMap<Tree, Map<Symbol, ReadWriteVisitor.SymbolReadWrite>>();
    }

    public Map<Symbol, ReadWriteVisitor.SymbolReadWrite> getSymbolReadWrites(Tree tree) {
        return this.variableReadWritesPerElement.get(tree);
    }

    protected void init(CfgBlock block) {
        HashSet<Symbol> writtenOnly = new HashSet<Symbol>();
        for (Tree element : block.elements()) {
            ReadWriteVisitor readWriteVisitor = new ReadWriteVisitor();
            element.accept(readWriteVisitor);
            this.variableReadWritesPerElement.put(element, readWriteVisitor.symbolToUsages());
            this.computeGenAndKill(writtenOnly, readWriteVisitor.symbolToUsages());
        }
    }

    private void computeGenAndKill(Set<Symbol> writtenOnly, Map<Symbol, ReadWriteVisitor.SymbolReadWrite> symbolToUsages) {
        for (Map.Entry<Symbol, ReadWriteVisitor.SymbolReadWrite> symbolListEntry : symbolToUsages.entrySet()) {
            Symbol symbol = symbolListEntry.getKey();
            ReadWriteVisitor.SymbolReadWrite usage = symbolListEntry.getValue();
            if (usage.isRead() && !writtenOnly.contains(symbol)) {
                this.gen.add(symbol);
            }
            if (!usage.isWrite()) continue;
            this.kill.add(symbol);
            if (usage.isRead()) continue;
            writtenOnly.add(symbol);
        }
    }

    public Set<Symbol> getGen() {
        return this.gen;
    }

    public Set<Symbol> getKill() {
        return this.kill;
    }

    public boolean isSymbolUsedInBlock(Symbol symbol) {
        return this.variableReadWritesPerElement.values().stream().flatMap(m -> m.keySet().stream()).anyMatch(s -> s == symbol);
    }
}

