/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;

public class PythonProfile
implements BuiltInQualityProfilesDefinition {
    private static final Logger LOG = Loggers.get(PythonProfile.class);
    static final String PROFILE_NAME = "Sonar way";
    static final String PROFILE_LOCATION = "org/sonar/l10n/py/rules/python/Sonar_way_profile.json";
    static final String SECURITY_RULES_CLASS_NAME = "com.sonar.plugins.security.api.PythonRules";
    static final String SECURITY_RULE_KEYS_METHOD_NAME = "getRuleKeys";
    static final String SECURITY_RULE_REPO_METHOD_NAME = "getRepositoryKey";

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile = context.createBuiltInQualityProfile(PROFILE_NAME, "py");
        BuiltInQualityProfileJsonLoader.load(profile, "python", PROFILE_LOCATION);
        PythonProfile.getSecurityRuleKeys(SECURITY_RULES_CLASS_NAME, SECURITY_RULE_KEYS_METHOD_NAME, SECURITY_RULE_REPO_METHOD_NAME).forEach(key -> profile.activateRule(key.repository(), key.rule()));
        profile.done();
    }

    static Set<RuleKey> getSecurityRuleKeys(String className, String ruleKeysMethodName, String ruleRepoMethodName) {
        try {
            Class<?> rulesClass = Class.forName(className);
            Method getRuleKeysMethod = rulesClass.getMethod(ruleKeysMethodName, new Class[0]);
            Set ruleKeys = (Set)getRuleKeysMethod.invoke(null, new Object[0]);
            Method getRepositoryKeyMethod = rulesClass.getMethod(ruleRepoMethodName, new Class[0]);
            String repositoryKey = (String)getRepositoryKeyMethod.invoke(null, new Object[0]);
            return ruleKeys.stream().map(k -> RuleKey.of((String)repositoryKey, (String)k)).collect(Collectors.toSet());
        }
        catch (ClassNotFoundException e) {
            LOG.debug(className + " is not found, " + PythonProfile.securityRuleMessage(e));
        }
        catch (NoSuchMethodException e) {
            LOG.debug("Method not found on " + className + ", " + PythonProfile.securityRuleMessage(e));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.debug(e.getClass().getSimpleName() + ": " + PythonProfile.securityRuleMessage(e));
        }
        return Collections.emptySet();
    }

    private static String securityRuleMessage(Exception e) {
        return "no security rules added to Sonar way Python profile: " + e.getMessage();
    }
}

