/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.text.core;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;

public class InputFileContext {
    public final SensorContext sensorContext;
    public final InputFile inputFile;
    private final Set<Integer> raisedIssues = new HashSet<Integer>();

    public InputFileContext(SensorContext sensorContext, InputFile inputFile) {
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
    }

    public void reportLineIssue(RuleKey ruleKey, int line, String message) {
        if (this.raisedIssues.add(InputFileContext.issueHash(ruleKey, line))) {
            NewIssue issue = this.sensorContext.newIssue();
            NewIssueLocation issueLocation = issue.newLocation().on((InputComponent)this.inputFile).at(this.inputFile.selectLine(line)).message(message);
            issue.forRule(ruleKey).at(issueLocation);
            issue.save();
        }
    }

    public void reportAnalysisError(String message) {
        NewAnalysisError error = this.sensorContext.newAnalysisError();
        error.message(message).onFile(this.inputFile);
        error.save();
    }

    private static int issueHash(RuleKey ruleKey, int line) {
        return Objects.hash(ruleKey, line);
    }
}

