/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.parser;

import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.CommentImpl;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.tree.impl.SyntaxTokenImpl;
import org.sonar.iac.terraform.tree.impl.TerraformTreeImpl;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class HclNodeBuilder
implements NodeBuilder {
    public static final char BYTE_ORDER_MARK = '\ufeff';

    @Override
    public Object createNonTerminal(GrammarRuleKey ruleKey, Rule rule, List<Object> children, int startIndex, int endIndex) {
        for (Object child : children) {
            if (!(child instanceof SyntaxTokenImpl)) continue;
            return child;
        }
        return new TerraformTreeImpl(){

            @Override
            public List<Tree> children() {
                throw new UnsupportedOperationException();
            }

            @Override
            public TerraformTree.Kind getKind() {
                return TerraformTree.Kind.TOKEN;
            }
        };
    }

    @Override
    public Object createTerminal(Input input, int startIndex, int endIndex, List<Trivia> trivias, TokenType type) {
        String value = input.substring(startIndex, endIndex);
        TextRange range = HclNodeBuilder.tokenRange(input, startIndex, value);
        return new SyntaxTokenImpl(value, range, HclNodeBuilder.createComments(trivias));
    }

    private static TextRange tokenRange(Input input, int startIndex, String value) {
        int[] lineAndColumn = input.lineAndColumnAt(startIndex);
        char[] fileChars = input.input();
        boolean hasByteOrderMark = fileChars.length > 0 && fileChars[0] == '\ufeff';
        int column = HclNodeBuilder.applyByteOrderMark(lineAndColumn[1], hasByteOrderMark) - 1;
        return TextRanges.range(lineAndColumn[0], column, value);
    }

    private static int applyByteOrderMark(int column, boolean hasByteOrderMark) {
        return hasByteOrderMark ? column - 1 : column;
    }

    private static List<Comment> createComments(List<Trivia> trivias) {
        ArrayList<Comment> result = new ArrayList<Comment>();
        for (Trivia trivia : trivias) {
            Token triviaToken = trivia.getToken();
            String text = triviaToken.getValue();
            TextRange range = TextRanges.range(triviaToken.getLine(), triviaToken.getColumn(), text);
            result.add(new CommentImpl(text, HclNodeBuilder.getCommentContent(text), range));
        }
        return result;
    }

    private static String getCommentContent(String comment) {
        if (comment.startsWith("//")) {
            return comment.substring(2);
        }
        if (comment.startsWith("#")) {
            return comment.substring(1);
        }
        return comment.substring(2, comment.length() - 2);
    }
}

