/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.ResourceVisitor;

public class AzureClearTextProtocolsCheckPart
extends ResourceVisitor {
    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, this::checkStorageAccountDataSource);
        super.initialize(init);
    }

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_spring_cloud_app", "azurerm_function_app", "azurerm_function_app_slot", "azurerm_app_service"), (ResourceVisitor.Resource resource) -> resource.attribute("https_only").reportIfAbsence("Omitting %s enables clear-text traffic. Make sure it is safe here.").reportIfFalse("Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_app_service", (ResourceVisitor.Resource resource) -> resource.block("site_config").ifPresent(block -> block.attribute("ftps_state").reportIfValueMatches("AllAllowed", "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0])));
        this.register("azurerm_cdn_endpoint", (ResourceVisitor.Resource resource) -> resource.attribute("is_http_allowed").reportIfAbsence("Omitting %s enables clear-text traffic. Make sure it is safe here.").reportIfTrue("Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_redis_enterprise_database", (ResourceVisitor.Resource resource) -> resource.attribute("client_protocol").reportIfValueMatches("PLAINTEXT", "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register(List.of("azurerm_mysql_server", "azurerm_postgresql_server"), (ResourceVisitor.Resource resource) -> resource.attribute("ssl_enforcement_enabled").reportIfFalse("Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_storage_account", (ResourceVisitor.Resource resource) -> resource.attribute("enable_https_traffic_only").reportIfFalse("Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_api_management_api", (ResourceVisitor.Resource resource) -> resource.list("protocols").reportItemsWhichMatch(itemTree -> TextUtils.isValue(itemTree, "http").isTrue(), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
    }

    private void checkStorageAccountDataSource(CheckContext ctx, BlockTree tree) {
        if ("azurerm_storage_account_blob_container_sas".equals(AzureClearTextProtocolsCheckPart.getDataSourceType(tree))) {
            new ResourceVisitor.Block(ctx, tree).attribute("https_only").reportIfFalse("Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]);
        }
    }

    @Nullable
    private static String getDataSourceType(BlockTree tree) {
        return "data".equals(tree.key().value()) ? AbstractResourceCheck.getResourceType(tree) : null;
    }
}

