/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6319")
public class UnencryptedSageMakerNotebookCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted SageMaker notebook instances is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(UnencryptedSageMakerNotebookCheck::checkInstance, "aws_sagemaker_notebook_instance");
    }

    private static void checkInstance(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "kms_key_id")) {
            UnencryptedSageMakerNotebookCheck.reportResource(ctx, resource, MESSAGE);
        }
    }
}

