/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6327")
public class DisabledSNSTopicEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted SNS topics is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(DisabledSNSTopicEncryptionCheck::checkSnsTopic, "aws_sns_topic");
    }

    private static void checkSnsTopic(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "kms_master_key_id")) {
            DisabledSNSTopicEncryptionCheck.reportResource(ctx, resource, MESSAGE);
        }
    }
}

