/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.LiteralExprTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6258")
public class DisabledLoggingCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that disabling logging is safe here.";
    private static final String MESSAGE_OMITTING = "Omitting %s makes logs incomplete. Make sure it is safe here.";
    private static final List<String> MSK_LOGGER = Arrays.asList("cloudwatch_logs", "firehose", "s3");

    @Override
    protected void registerResourceChecks() {
        this.register(DisabledLoggingCheck::checkS3Bucket, "aws_s3_bucket");
        this.register(DisabledLoggingCheck::checkApiGatewayStage, "aws_api_gateway_stage");
        this.register(DisabledLoggingCheck::checkApiGateway2Stage, "aws_api_gatewayv2_stage", "aws_api_gateway_stage");
        this.register(DisabledLoggingCheck::checkMskCluster, "aws_msk_cluster");
        this.register(DisabledLoggingCheck::checkNeptuneCluster, "aws_neptune_cluster");
        this.register(DisabledLoggingCheck::checkDocDbCluster, "aws_docdb_cluster");
        this.register(DisabledLoggingCheck::checkMqBroker, "aws_mq_broker");
        this.register(DisabledLoggingCheck::checkRedshiftCluster, "aws_redshift_cluster");
        this.register(DisabledLoggingCheck::checkGlobalAccelerator, "aws_globalaccelerator_accelerator");
        this.register(DisabledLoggingCheck::checkElasticSearchDomain, "aws_elasticsearch_domain");
        this.register(DisabledLoggingCheck::checkCloudfrontDistribution, "aws_cloudfront_distribution");
        this.register((ctx, resource) -> DisabledLoggingCheck.checkElasticLoadBalancing(ctx, resource, false), "aws_lb");
        this.register((ctx, resource) -> DisabledLoggingCheck.checkElasticLoadBalancing(ctx, resource, true), "aws_elb");
    }

    private static void checkS3Bucket(CheckContext ctx, BlockTree resource) {
        if (!DisabledLoggingCheck.isMaybeLoggingBucket(resource) && PropertyUtils.isMissing(resource, "logging")) {
            DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "logging or acl=\"log-delivery-write\""));
        }
    }

    private static boolean isMaybeLoggingBucket(BlockTree resource) {
        Optional<AttributeTree> acl = PropertyUtils.get(resource, "acl", AttributeTree.class);
        if (acl.isEmpty()) {
            return false;
        }
        ExpressionTree aclValue = acl.get().value();
        if (aclValue.is(TerraformTree.Kind.STRING_LITERAL)) {
            return ((LiteralExprTree)aclValue).value().equals("log-delivery-write");
        }
        return true;
    }

    private static void checkApiGatewayStage(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "xray_tracing_enabled", AttributeTree.class).ifPresentOrElse(tracing -> DisabledLoggingCheck.reportOnFalse(ctx, tracing, MESSAGE, new SecondaryLocation[0]), () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "xray_tracing_enabled")));
    }

    private static void checkApiGateway2Stage(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "access_log_settings")) {
            DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "access_log_settings"));
        }
    }

    private static void checkMskCluster(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "logging_info", BlockTree.class).ifPresentOrElse(info -> PropertyUtils.get(info, "broker_logs", BlockTree.class).ifPresentOrElse(logs -> DisabledLoggingCheck.checkMskLogs(ctx, logs), () -> ctx.reportIssue(info.key(), String.format(MESSAGE_OMITTING, "broker_logs"))), () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "logging_info.broker_logs")));
    }

    private static void checkMskLogs(CheckContext ctx, Tree logs) {
        if (MSK_LOGGER.stream().noneMatch(name -> PropertyUtils.get(logs, name, BlockTree.class).filter(DisabledLoggingCheck::isLogEnabled).isPresent())) {
            ctx.reportIssue(((PropertyTree)((Object)logs)).key(), String.format(MESSAGE_OMITTING, "cloudwatch_logs, firehose or s3"));
        }
    }

    private static boolean isLogEnabled(BlockTree logger) {
        return PropertyUtils.value((Tree)logger, "enabled").filter(TextUtils::isValueFalse).isEmpty();
    }

    private static void checkNeptuneCluster(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "enable_cloudwatch_logs_exports", AttributeTree.class).ifPresentOrElse(exports -> {
            if (exports.value() instanceof TupleTree && ((TupleTree)exports.value()).elements().trees().isEmpty()) {
                ctx.reportIssue((HasTextRange)exports, MESSAGE);
            }
        }, () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "enable_cloudwatch_logs_exports")));
    }

    private static void checkDocDbCluster(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "enabled_cloudwatch_logs_exports", AttributeTree.class).ifPresentOrElse(exportsProperty -> {
            if (exportsProperty.value() instanceof TupleTree && DisabledLoggingCheck.containsOnlyStringsWithoutAudit((TupleTree)exportsProperty.value())) {
                ctx.reportIssue((HasTextRange)exportsProperty, MESSAGE);
            }
        }, () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "enabled_cloudwatch_logs_exports")));
    }

    private static boolean containsOnlyStringsWithoutAudit(TupleTree exports) {
        return exports.elements().trees().stream().allMatch(export -> TextUtils.isValue(export, "audit").isFalse());
    }

    private static void checkMqBroker(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "logs", BlockTree.class).ifPresentOrElse(logs -> {
            if (DisabledLoggingCheck.containsOnlyFalse(logs)) {
                ctx.reportIssue(logs.key(), MESSAGE);
            }
        }, () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "logs.audit or logs.general")));
    }

    private static boolean containsOnlyFalse(BlockTree logs) {
        return PropertyUtils.getAll((Tree)logs, AttributeTree.class).stream().map(AttributeTree::value).allMatch(TextUtils::isValueFalse);
    }

    private static void checkRedshiftCluster(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "logging", BlockTree.class).ifPresentOrElse(logging -> DisabledLoggingCheck.reportOnDisabled(ctx, logging, false, MESSAGE, "enable"), () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "logging.enable")));
    }

    private static void checkGlobalAccelerator(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "attributes", BlockTree.class).ifPresentOrElse(attributes -> DisabledLoggingCheck.reportOnDisabled(ctx, attributes, false, MESSAGE, "flow_logs_enabled"), () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "attributes.flow_logs_enabled")));
    }

    private static void checkElasticSearchDomain(CheckContext ctx, BlockTree resource) {
        PropertyUtils.getAll(resource, "log_publishing_options", BlockTree.class).stream().filter(DisabledLoggingCheck::isAuditLog).findFirst().ifPresentOrElse(auditLog -> DisabledLoggingCheck.reportOnDisabled(ctx, auditLog, true, MESSAGE), () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "log_publishing_options of type \"AUDIT_LOGS\"")));
    }

    private static boolean isAuditLog(BlockTree logOption) {
        return PropertyUtils.value((Tree)logOption, "log_type").filter(type -> !TextUtils.isValue(type, "AUDIT_LOGS").isFalse()).isPresent();
    }

    private static void checkCloudfrontDistribution(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "logging_config")) {
            DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "logging_config"));
        }
    }

    private static void checkElasticLoadBalancing(CheckContext ctx, BlockTree resource, boolean enabledByDefault) {
        PropertyUtils.get(resource, "access_logs", BlockTree.class).ifPresentOrElse(logs -> DisabledLoggingCheck.reportOnDisabled(ctx, logs, enabledByDefault, MESSAGE), () -> DisabledLoggingCheck.reportResource(ctx, resource, String.format(MESSAGE_OMITTING, "access_logs")));
    }

    private static void reportOnDisabled(CheckContext ctx, BlockTree block, boolean enabledByDefault, String message) {
        DisabledLoggingCheck.reportOnDisabled(ctx, block, enabledByDefault, message, "enabled");
    }

    private static void reportOnDisabled(CheckContext ctx, BlockTree block, boolean enabledByDefault, String message, String enablingKey) {
        PropertyUtils.get(block, enablingKey, AttributeTree.class).ifPresentOrElse(enabled -> DisabledLoggingCheck.reportOnFalse(ctx, enabled, message, new SecondaryLocation[0]), () -> {
            if (!enabledByDefault) {
                ctx.reportIssue(block.key(), message);
            }
        });
    }
}

