/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;

public abstract class AbstractResourceCheck
implements IacCheck {
    protected static final String S3_BUCKET = "aws_s3_bucket";
    private final Map<String, List<BiConsumer<CheckContext, BlockTree>>> resourceChecks = new HashMap<String, List<BiConsumer<CheckContext, BlockTree>>>();
    private final List<BiConsumer<CheckContext, BlockTree>> allResourcesChecks = new ArrayList<BiConsumer<CheckContext, BlockTree>>();

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, (CheckContext ctx, T tree) -> {
            if (AbstractResourceCheck.isResource(tree)) {
                this.checkResource((CheckContext)ctx, (BlockTree)tree);
            }
        });
        this.registerResourceChecks();
    }

    protected void registerResourceChecks() {
    }

    protected void register(BiConsumer<CheckContext, BlockTree> resourceCheck) {
        this.allResourcesChecks.add(resourceCheck);
    }

    protected void register(BiConsumer<CheckContext, BlockTree> resourceCheck, String ... resourceNames) {
        Arrays.asList(resourceNames).forEach(resourceName -> this.resourceChecks.computeIfAbsent((String)resourceName, i -> new ArrayList()).add(resourceCheck));
    }

    protected void checkResource(CheckContext ctx, BlockTree resource) {
        String resourceType = AbstractResourceCheck.getResourceType(resource);
        if (this.resourceChecks.containsKey(resourceType)) {
            this.resourceChecks.get(resourceType).forEach(consumer -> consumer.accept(ctx, resource));
        }
        this.allResourcesChecks.forEach(consumer -> consumer.accept(ctx, resource));
    }

    public static boolean isResource(BlockTree tree) {
        return TextUtils.matchesValue(tree.key(), "resource"::equals).isTrue();
    }

    public static boolean isResource(BlockTree tree, String type) {
        return AbstractResourceCheck.isResource(tree) && type.equals(AbstractResourceCheck.getResourceType(tree));
    }

    public static String getReferenceLabel(BlockTree resource) {
        return resource.labels().get(1).value();
    }

    public static boolean hasReferenceLabel(BlockTree resource) {
        return resource.labels().size() >= 2;
    }

    public static boolean isS3Bucket(BlockTree tree) {
        return S3_BUCKET.equals(AbstractResourceCheck.getResourceType(tree));
    }

    public static boolean isS3BucketResource(BlockTree tree) {
        return AbstractResourceCheck.isResource(tree, S3_BUCKET);
    }

    @CheckForNull
    public static String getResourceType(BlockTree tree) {
        return tree.labels().isEmpty() ? null : tree.labels().get(0).value();
    }

    public static void reportResource(CheckContext ctx, BlockTree resource, String message) {
        ctx.reportIssue(resource.labels().get(0), message);
    }

    protected static void reportOnTrue(CheckContext ctx, AttributeTree attribute, String message, SecondaryLocation ... secondaries) {
        if (TextUtils.isValueTrue(attribute.value())) {
            ctx.reportIssue((HasTextRange)attribute, message, Arrays.asList(secondaries));
        }
    }

    protected static void reportOnFalse(CheckContext ctx, AttributeTree attribute, String message, SecondaryLocation ... secondaries) {
        if (TextUtils.isValueFalse(attribute.value())) {
            ctx.reportIssue((HasTextRange)attribute, message, Arrays.asList(secondaries));
        }
    }

    protected static void reportUnexpectedValue(CheckContext ctx, AttributeTree attribute, String expectedValue, String message, SecondaryLocation ... secondaries) {
        if (TextUtils.isValue(attribute.value(), expectedValue).isFalse()) {
            ctx.reportIssue((HasTextRange)attribute, message, Arrays.asList(secondaries));
        }
    }

    protected static void reportSensitiveValue(CheckContext ctx, AttributeTree attribute, String sensitiveValue, String message, SecondaryLocation ... secondaries) {
        if (TextUtils.isValue(attribute.value(), sensitiveValue).isTrue()) {
            ctx.reportIssue((HasTextRange)attribute, message, Arrays.asList(secondaries));
        }
    }
}

