/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6281")
public class BucketsPublicAclOrPolicyCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure not preventing permissive ACL/policies to be set is safe here.";
    private static final String SECONDARY_MSG_PROPERTY = "Set this property to true";
    private static final String SECONDARY_MSG_BUCKET = "Related bucket";
    private static final List<String> ATTRIBUTES_TO_CHECK = Arrays.asList("BlockPublicAcls", "BlockPublicPolicy", "IgnorePublicAcls", "RestrictPublicBuckets");

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!BucketsPublicAclOrPolicyCheck.isS3Bucket(resource)) {
            return;
        }
        Optional<CloudformationTree> accessConfiguration = PropertyUtils.value(resource.properties(), "PublicAccessBlockConfiguration", CloudformationTree.class);
        if (accessConfiguration.isPresent()) {
            BucketsPublicAclOrPolicyCheck.checkConfiguration(ctx, resource, accessConfiguration.get());
        } else {
            ctx.reportIssue(resource.type(), MESSAGE);
        }
    }

    private static void checkConfiguration(CheckContext ctx, AbstractResourceCheck.Resource resource, CloudformationTree configuration) {
        List<SecondaryLocation> problemsAsSecondaryLocations = BucketsPublicAclOrPolicyCheck.configurationProblemsAsSecondaryLocations(configuration);
        Tree primaryLocationTree = PropertyUtils.key(resource.properties(), "PublicAccessBlockConfiguration").orElse(configuration);
        if (!problemsAsSecondaryLocations.isEmpty() || BucketsPublicAclOrPolicyCheck.hasMissingSetting(configuration)) {
            problemsAsSecondaryLocations.add(new SecondaryLocation(resource.type(), SECONDARY_MSG_BUCKET));
            ctx.reportIssue((HasTextRange)primaryLocationTree, MESSAGE, problemsAsSecondaryLocations);
        }
    }

    private static boolean hasMissingSetting(CloudformationTree configuration) {
        return ATTRIBUTES_TO_CHECK.stream().anyMatch(a -> PropertyUtils.isMissing(configuration, a));
    }

    private static List<SecondaryLocation> configurationProblemsAsSecondaryLocations(CloudformationTree configuration) {
        ArrayList<SecondaryLocation> problems = new ArrayList<SecondaryLocation>();
        ATTRIBUTES_TO_CHECK.forEach(attribute -> PropertyUtils.value((Tree)configuration, attribute).filter(TextUtils::isValueFalse).ifPresent(c -> problems.add(new SecondaryLocation((HasTextRange)c, SECONDARY_MSG_PROPERTY))));
        return problems;
    }
}

