/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.Flow;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@Rule(key="S4449")
public class ParameterNullnessCheck
extends SECheck {
    private static final MethodMatchers AUTHORIZED_METHODS = MethodMatchers.or(MethodMatchers.create().ofTypes("com.google.common.base.Preconditions").names("checkNotNull").withAnyParameters().build(), ExplodedGraphWalker.EQUALS_METHODS);

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        ProgramState state = context.getState();
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mit = (MethodInvocationTree)syntaxNode;
            this.checkParameters(mit, mit.symbol(), mit.arguments(), state);
        } else if (syntaxNode.is(Tree.Kind.NEW_CLASS)) {
            NewClassTree nct = (NewClassTree)syntaxNode;
            this.checkParameters(nct, nct.constructorSymbol(), nct.arguments(), state);
        }
        return state;
    }

    private void checkParameters(Tree syntaxNode, Symbol symbol, Arguments arguments, ProgramState state) {
        if (!symbol.isMethodSymbol() || arguments.isEmpty()) {
            return;
        }
        if (AUTHORIZED_METHODS.matches(symbol)) {
            return;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        int nbArguments = arguments.size();
        List<SymbolicValue> argumentSVs = ParameterNullnessCheck.getArgumentSVs(state, syntaxNode, nbArguments);
        int nbArgumentToCheck = Math.min(nbArguments, methodSymbol.parameterTypes().size() - (JUtils.isVarArgsMethod(methodSymbol) ? 1 : 0));
        List<Symbol> parameterSymbols = methodSymbol.declarationParameters();
        for (int i = 0; i < nbArgumentToCheck; ++i) {
            ObjectConstraint constraint = state.getConstraint(argumentSVs.get(i), ObjectConstraint.class);
            if (constraint == null || !constraint.isNull() || !ParameterNullnessCheck.parameterIsNonNullIndirectly(parameterSymbols.get(i))) continue;
            this.reportIssue(syntaxNode, (ExpressionTree)arguments.get(i), methodSymbol);
        }
    }

    private void reportIssue(Tree syntaxNode, ExpressionTree argument, Symbol.MethodSymbol methodSymbol) {
        Object declarationMessage = "constructor declaration";
        if (!"<init>".equals(methodSymbol.name())) {
            declarationMessage = "method '" + methodSymbol.name() + "' declaration";
        }
        String message = String.format("Annotate the parameter with @javax.annotation.Nullable in %s, or make sure that null can not be passed as argument.", declarationMessage);
        TypeTree reportTree = syntaxNode.is(Tree.Kind.METHOD_INVOCATION) ? ExpressionUtils.methodName((MethodInvocationTree)syntaxNode) : ((NewClassTree)syntaxNode).identifier();
        Flow.Builder secondaryBuilder = Flow.builder();
        MethodTree declarationTree = methodSymbol.declaration();
        if (declarationTree != null) {
            secondaryBuilder.add(new JavaFileScannerContext.Location(StringUtils.capitalize((String)declarationMessage) + ".", declarationTree.simpleName()));
        }
        secondaryBuilder.add(new JavaFileScannerContext.Location("Argument can be null.", argument));
        this.reportIssue((Tree)reportTree, message, Collections.singleton(secondaryBuilder.build()));
    }

    private static List<SymbolicValue> getArgumentSVs(ProgramState state, Tree syntaxNode, int nbArguments) {
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            return ListUtils.reverse(state.peekValues(nbArguments + 1).subList(0, nbArguments));
        }
        return ListUtils.reverse(state.peekValues(nbArguments));
    }

    private static boolean parameterIsNonNullIndirectly(Symbol symbol) {
        SymbolMetadata.NullabilityData nullabilityData = symbol.metadata().nullabilityData();
        return nullabilityData.isNonNull(SymbolMetadata.NullabilityLevel.PACKAGE, false, false) && nullabilityData.level() != SymbolMetadata.NullabilityLevel.VARIABLE;
    }
}

