/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.ExceptionalCheckBasedYield;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class ExceptionalYieldChecker {
    private final String message;

    ExceptionalYieldChecker(String message) {
        this.message = message;
    }

    void reportOnExceptionalYield(ExplodedGraph.Node node, SECheck check) {
        node.edges().stream().forEach(edge -> edge.yields().stream().filter(methodYield -> methodYield.generatedByCheck(check)).forEach(methodYield -> this.reportIssue(edge.parent(), (ExceptionalCheckBasedYield)methodYield, check)));
    }

    private void reportIssue(ExplodedGraph.Node node, ExceptionalCheckBasedYield exceptionalYield, SECheck check) {
        int parameterCausingExceptionIndex;
        IdentifierTree identifierTree;
        MethodInvocationTree mit = (MethodInvocationTree)node.programPoint.syntaxTree();
        ExpressionTree methodSelect = mit.methodSelect();
        String methodName = mit.symbol().name();
        ExpressionTree reportTree = methodSelect;
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            reportTree = ((MemberSelectExpressionTree)methodSelect).identifier();
        }
        JavaFileScannerContext.Location methodInvocationMessage = (identifierTree = FlowComputation.getArgumentIdentifier(mit, parameterCausingExceptionIndex = exceptionalYield.parameterCausingExceptionIndex())) != null ? new JavaFileScannerContext.Location(String.format("'%s' is passed to '%s()'.", identifierTree.name(), methodName), identifierTree) : new JavaFileScannerContext.Location(String.format("'%s()' is invoked.", methodName), reportTree);
        Flow argumentChangingNameFlows = ExceptionalYieldChecker.flowsForArgumentsChangingName(exceptionalYield, mit);
        Set<Flow> argumentsFlows = ExceptionalYieldChecker.flowsForMethodArguments(node, mit, parameterCausingExceptionIndex, 20);
        Set<Flow> exceptionFlows = exceptionalYield.exceptionFlows(20);
        HashSet<Flow> flows = new HashSet<Flow>();
        for (Flow argumentFlow : argumentsFlows) {
            for (Flow exceptionFlow : exceptionFlows) {
                flows.add(Flow.builder().addAll(exceptionFlow).addAll(argumentChangingNameFlows).add(methodInvocationMessage).addAll(argumentFlow).build());
            }
        }
        check.reportIssue(reportTree, String.format(this.message, methodName), Collections.unmodifiableSet(flows));
    }

    private static Set<Flow> flowsForMethodArguments(ExplodedGraph.Node node, MethodInvocationTree mit, int parameterCausingExceptionIndex, int maxReturnedFlows) {
        ProgramState programState = node.programState;
        List<ProgramState.SymbolicValueSymbol> arguments = ListUtils.reverse(programState.peekValuesAndSymbols(mit.arguments().size()));
        SymbolicValue parameterCausingExceptionSV = arguments.get(parameterCausingExceptionIndex).symbolicValue();
        LinkedHashSet<SymbolicValue> argSymbolicValues = new LinkedHashSet<SymbolicValue>();
        LinkedHashSet<Symbol> argSymbols = new LinkedHashSet<Symbol>();
        arguments.stream().filter(svs -> parameterCausingExceptionSV == svs.symbolicValue() || ExceptionalYieldChecker.hasConstraintOtherThanNonNull(svs, programState)).forEach(svs -> {
            argSymbolicValues.add(svs.symbolicValue());
            Symbol symbol = svs.symbol();
            if (symbol != null) {
                argSymbols.add(symbol);
            }
        });
        List<Class<? extends Constraint>> domains = ExceptionalYieldChecker.domainsFromArguments(programState, argSymbolicValues);
        return FlowComputation.flow(node, argSymbolicValues, c -> true, c -> false, domains, argSymbols, maxReturnedFlows);
    }

    private static boolean hasConstraintOtherThanNonNull(ProgramState.SymbolicValueSymbol svs, ProgramState ps) {
        SymbolicValue sv = svs.symbolicValue();
        ConstraintsByDomain constraints = ps.getConstraints(sv);
        return constraints != null && !ExceptionalYieldChecker.hasOnlyNonNullConstraint(constraints);
    }

    private static boolean hasOnlyNonNullConstraint(ConstraintsByDomain constraints) {
        return constraints.domains().count() == 1L && constraints.get(ObjectConstraint.class) == ObjectConstraint.NOT_NULL;
    }

    private static List<Class<? extends Constraint>> domainsFromArguments(ProgramState programState, Collection<SymbolicValue> arguments) {
        return arguments.stream().map(programState::getConstraints).filter(Objects::nonNull).flatMap(ConstraintsByDomain::domains).distinct().collect(Collectors.toList());
    }

    private static Flow flowsForArgumentsChangingName(ExceptionalCheckBasedYield exceptionalYield, MethodInvocationTree mit) {
        return FlowComputation.flowsForArgumentsChangingName(Collections.singletonList(exceptionalYield.parameterCausingExceptionIndex()), mit);
    }
}

