/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeTree;

public class NewClassTreeImpl
extends AssessableExpressionTree
implements NewClassTree {
    @Nullable
    private ExpressionTree enclosingExpression = null;
    @Nullable
    private SyntaxToken dotToken;
    @Nullable
    private SyntaxToken newKeyword;
    @Nullable
    private TypeArguments typeArguments;
    private TypeTree identifier;
    private final Arguments arguments;
    @Nullable
    private final ClassTree classBody;

    public NewClassTreeImpl(TypeTree identifier, Arguments arguments, @Nullable ClassTreeImpl classBody) {
        this.identifier = identifier;
        this.arguments = arguments;
        this.classBody = classBody;
    }

    public NewClassTreeImpl completeWithEnclosingExpression(ExpressionTree enclosingExpression) {
        this.enclosingExpression = enclosingExpression;
        return this;
    }

    public NewClassTreeImpl completeWithNewKeyword(SyntaxToken newKeyword) {
        this.newKeyword = newKeyword;
        return this;
    }

    public NewClassTreeImpl completeWithTypeArguments(@Nullable TypeArgumentListTreeImpl typeArguments) {
        this.typeArguments = typeArguments;
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.NEW_CLASS;
    }

    @Override
    @Nullable
    public ExpressionTree enclosingExpression() {
        return this.enclosingExpression;
    }

    @Override
    @Nullable
    public TypeArguments typeArguments() {
        return this.typeArguments;
    }

    @Override
    public TypeTree identifier() {
        return this.identifier;
    }

    @Override
    public Arguments arguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public ClassTree classBody() {
        return this.classBody;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNewClass(this);
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> builder = new ArrayList<Tree>();
        NewClassTreeImpl.addIfNotNull(builder, this.enclosingExpression, this.dotToken, this.newKeyword, this.typeArguments);
        builder.add(this.identifier);
        builder.add(this.arguments);
        NewClassTreeImpl.addIfNotNull(builder, this.classBody);
        return Collections.unmodifiableList(builder);
    }

    public IdentifierTree getConstructorIdentifier() {
        return NewClassTreeImpl.getConstructorIdentifier(this.identifier());
    }

    private static IdentifierTree getConstructorIdentifier(Tree constructorSelect) {
        IdentifierTree constructorIdentifier;
        if (constructorSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)constructorSelect;
            constructorIdentifier = mset.identifier();
        } else if (constructorSelect.is(Tree.Kind.IDENTIFIER)) {
            constructorIdentifier = (IdentifierTree)constructorSelect;
        } else if (constructorSelect.is(Tree.Kind.PARAMETERIZED_TYPE)) {
            constructorIdentifier = NewClassTreeImpl.getConstructorIdentifier(((ParameterizedTypeTree)constructorSelect).type());
        } else {
            throw new IllegalStateException("Constructor select is not of the expected type " + constructorSelect);
        }
        return constructorIdentifier;
    }

    @Override
    @Nullable
    public SyntaxToken newKeyword() {
        return this.newKeyword;
    }

    public void completeWithDotToken(InternalSyntaxToken dotToken) {
        this.dotToken = dotToken;
    }

    @Override
    @Nullable
    public SyntaxToken dotToken() {
        return this.dotToken;
    }

    @Override
    public Symbol constructorSymbol() {
        return this.getConstructorIdentifier().symbol();
    }

    private static void addIfNotNull(List<Tree> list, Tree ... trees) {
        for (Tree tree : trees) {
            if (tree == null) continue;
            list.add(tree);
        }
    }
}

