/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class MemberSelectExpressionTreeImpl
extends AssessableExpressionTree
implements MemberSelectExpressionTree,
JavaTree.AnnotatedTypeTree {
    private ExpressionTree expression;
    private InternalSyntaxToken dotToken;
    private final IdentifierTree identifier;
    private List<AnnotationTree> annotations;

    public MemberSelectExpressionTreeImpl(ExpressionTree expression, InternalSyntaxToken dotToken, IdentifierTree identifier) {
        this.expression = Objects.requireNonNull(expression);
        this.dotToken = dotToken;
        this.identifier = Objects.requireNonNull(identifier);
        this.annotations = Collections.emptyList();
    }

    @Override
    public void complete(List<AnnotationTree> annotations) {
        this.annotations = annotations;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.MEMBER_SELECT;
    }

    @Override
    public List<AnnotationTree> annotations() {
        return this.annotations;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken operatorToken() {
        return this.dotToken;
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMemberSelectExpression(this);
    }

    @Override
    public List<Tree> children() {
        return ListUtils.concat(this.annotations, Arrays.asList(this.expression, this.dotToken, this.identifier));
    }
}

