/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.JProblem;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.location.InternalPosition;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.Tree;

public final class JWarning
extends JProblem {
    private final Position start;
    private final Position end;
    private Tree syntaxTree;

    JWarning(String message, JProblem.Type type, int startLine, int startColumnOffset, int endLine, int endColumnOffset) {
        super(message, type);
        this.start = InternalPosition.atOffset(startLine, startColumnOffset);
        this.end = InternalPosition.atOffset(endLine, endColumnOffset);
    }

    public Tree syntaxTree() {
        return this.syntaxTree;
    }

    Position start() {
        return this.start;
    }

    Position end() {
        return this.end;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWarning)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JWarning jWarning = (JWarning)o;
        return this.start.equals(jWarning.start) && this.end.equals(jWarning.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.start, this.end);
    }

    public static class Mapper
    extends SubscriptionVisitor {
        private static final Set<Tree.Kind> KINDS = Stream.of(JProblem.Type.values()).map(JProblem.Type::getKinds).flatMap(Collection::stream).collect(Collectors.toSet());
        private final Map<JProblem.Type, Set<JWarning>> warningsByType = new EnumMap<JProblem.Type, Set<JWarning>>(JProblem.Type.class);
        private final PriorityQueue<JWarning> warnings = new PriorityQueue<JWarning>(Comparator.comparing(JWarning::start).thenComparing(JWarning::end));

        private Mapper(CompilationUnit ast) {
            Stream.of(ast.getProblems()).map(problem -> Mapper.convert(problem, ast)).filter(Objects::nonNull).forEach(this.warnings::add);
        }

        @CheckForNull
        private static JWarning convert(IProblem problem, CompilationUnit root) {
            for (JProblem.Type type : JProblem.Type.values()) {
                if (!type.matches(problem)) continue;
                return new JWarning(problem.getMessage(), type, problem.getSourceLineNumber(), root.getColumnNumber(problem.getSourceStart()), root.getLineNumber(problem.getSourceEnd()), root.getColumnNumber(problem.getSourceEnd()) + 1);
            }
            return null;
        }

        public static Mapper warningsFor(CompilationUnit ast) {
            return new Mapper(ast);
        }

        public void mappedInto(JavaTree.CompilationUnitTreeImpl cut) {
            this.scanTree(cut);
            cut.addWarnings(this.warningsByType);
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return new ArrayList<Tree.Kind>(KINDS);
        }

        @Override
        public void visitNode(Tree tree) {
            if (this.warnings.isEmpty()) {
                return;
            }
            Iterator<JWarning> iterator = this.warnings.iterator();
            while (iterator.hasNext()) {
                JWarning warning = iterator.next();
                if (!Mapper.isInsideTree(warning, tree)) continue;
                Mapper.setSyntaxTree(warning, tree);
                this.warningsByType.computeIfAbsent(warning.type(), k -> new LinkedHashSet()).add(warning);
                if (!Mapper.matchesTreeExactly(warning)) continue;
                iterator.remove();
            }
        }

        @VisibleForTesting
        static void setSyntaxTree(JWarning warning, Tree tree) {
            if (warning.syntaxTree == null || Mapper.isMorePreciseTree(warning.syntaxTree, tree)) {
                warning.syntaxTree = tree;
            }
        }

        @VisibleForTesting
        static boolean isInsideTree(JWarning warning, Tree tree) {
            if (warning.type().getKinds().stream().noneMatch(xva$0 -> tree.is((Tree.Kind)xva$0))) {
                return false;
            }
            return warning.start().compareTo(tree.firstToken().range().start()) >= 0 && warning.end().compareTo(tree.lastToken().range().end()) <= 0;
        }

        @VisibleForTesting
        static boolean isMorePreciseTree(Tree currentTree, Tree newTree) {
            return newTree.firstToken().range().start().compareTo(currentTree.firstToken().range().start()) >= 0 && newTree.lastToken().range().end().compareTo(currentTree.lastToken().range().end()) <= 0;
        }

        @VisibleForTesting
        static boolean matchesTreeExactly(JWarning warning) {
            Tree syntaxTree = warning.syntaxTree();
            return warning.start().compareTo(syntaxTree.firstToken().range().start()) == 0 && warning.end().compareTo(syntaxTree.lastToken().range().end()) == 0;
        }
    }
}

