/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;

@Rule(key="S2326")
public class UnusedTypeParameterCheck
extends IssuableSubscriptionVisitor {
    private static final String ISSUE_MESSAGE = "%s is not used in the %s.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.RECORD, Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        TypeParameters typeParameters = tree.is(Tree.Kind.METHOD) ? ((MethodTree)tree).typeParameters() : ((ClassTree)tree).typeParameters();
        for (TypeParameterTree typeParameter : typeParameters) {
            Symbol symbol = JUtils.typeParameterTreeSymbol(typeParameter);
            if (symbol.isUnknown() || !symbol.usages().isEmpty()) continue;
            String message = String.format(ISSUE_MESSAGE, symbol.name(), tree.kind().name().toLowerCase(Locale.ROOT));
            this.reportIssue(typeParameter.identifier(), message);
        }
    }
}

