/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.java.model.JUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1481")
public class UnusedLocalVariableCheck
extends IssuableSubscriptionVisitor {
    private static final Tree.Kind[] INCREMENT_KINDS = new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT};
    private static final String MESSAGE = "Remove this unused \"%s\" local variable.";
    private static final UnresolvedIdentifiersVisitor UNRESOLVED_IDENTIFIERS_VISITOR = new UnresolvedIdentifiersVisitor();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.COMPILATION_UNIT, Tree.Kind.VARIABLE);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.COMPILATION_UNIT)) {
            UNRESOLVED_IDENTIFIERS_VISITOR.check(tree);
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        VariableTree variable;
        String name;
        boolean unresolved;
        if (tree.is(Tree.Kind.VARIABLE) && !(unresolved = UNRESOLVED_IDENTIFIERS_VISITOR.isUnresolved(name = (variable = (VariableTree)tree).simpleName().name())) && UnusedLocalVariableCheck.isProperLocalVariable(variable) && UnusedLocalVariableCheck.isUnused(variable.symbol())) {
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(variable.simpleName()).withMessage(String.format(MESSAGE, name)).withQuickFixes(() -> UnusedLocalVariableCheck.computeQuickFix(variable))).report();
        }
    }

    private static boolean isUnused(Symbol symbol) {
        return symbol.usages().stream().noneMatch(UnusedLocalVariableCheck::isRValue);
    }

    private static boolean isRValue(IdentifierTree tree) {
        Tree parent = UnusedLocalVariableCheck.skipParenthesesUpwards(tree.parent());
        if (parent instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)parent;
            return assignment.variable() != tree;
        }
        return !parent.is(INCREMENT_KINDS) || !parent.parent().is(Tree.Kind.EXPRESSION_STATEMENT);
    }

    private static Tree skipParenthesesUpwards(Tree tree) {
        while (tree.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            tree = tree.parent();
        }
        return tree;
    }

    private static boolean isProperLocalVariable(VariableTree variable) {
        Symbol symbol = variable.symbol();
        return JUtils.isLocalVariable(symbol) && !JUtils.isParameter(symbol) && !UnusedLocalVariableCheck.isDefinedInCatchClause(variable) && !UnusedLocalVariableCheck.isTryResource(variable);
    }

    private static boolean isDefinedInCatchClause(VariableTree variable) {
        return variable.parent().is(Tree.Kind.CATCH);
    }

    private static boolean isTryResource(VariableTree variable) {
        return variable.parent().is(Tree.Kind.LIST) && variable.parent().parent().is(Tree.Kind.TRY_STATEMENT);
    }

    private static List<JavaQuickFix> computeQuickFix(VariableTree variable) {
        return UnusedLocalVariableCheck.getQuickFixTextSpan(variable).map(textSpan -> Collections.singletonList(JavaQuickFix.newQuickFix("Remove unused local variable").addTextEdit(JavaTextEdit.removeTextSpan(textSpan)).build())).orElseGet(Collections::emptyList);
    }

    private static Optional<AnalyzerMessage.TextSpan> getQuickFixTextSpan(VariableTree variable) {
        if (!variable.symbol().usages().isEmpty()) {
            return Optional.empty();
        }
        Tree parent = variable.parent();
        SyntaxToken lastToken = variable.lastToken();
        if (parent.is(Tree.Kind.BLOCK, Tree.Kind.INITIALIZER, Tree.Kind.STATIC_INITIALIZER)) {
            Optional<VariableTree> followingVariable = QuickFixHelper.nextVariable(variable);
            if (followingVariable.isPresent()) {
                return Optional.of(AnalyzerMessage.textSpanBetween(variable.simpleName(), true, followingVariable.get().simpleName(), false));
            }
            Optional<SyntaxToken> precedingComma = UnusedLocalVariableCheck.getPrecedingComma(variable);
            if (precedingComma.isPresent()) {
                AnalyzerMessage.TextSpan value = AnalyzerMessage.textSpanBetween(precedingComma.get(), true, lastToken, false);
                return Optional.of(value);
            }
            return Optional.of(AnalyzerMessage.textSpanBetween((Tree)variable.firstToken(), (Tree)lastToken));
        }
        if (parent.is(Tree.Kind.LIST)) {
            ListTree variables = (ListTree)parent;
            if (variables.size() == 1) {
                return Optional.of(AnalyzerMessage.textSpanFor(variable));
            }
            if (lastToken.text().equals(",")) {
                return Optional.of(AnalyzerMessage.textSpanBetween(variable.simpleName(), (Tree)lastToken));
            }
            SyntaxToken precedingComma = ((VariableTree)variables.get(variables.indexOf(variable) - 1)).lastToken();
            return Optional.of(AnalyzerMessage.textSpanBetween((Tree)precedingComma, (Tree)lastToken));
        }
        if (parent.is(Tree.Kind.PATTERN_INSTANCE_OF)) {
            return Optional.of(AnalyzerMessage.textSpanFor(lastToken));
        }
        return Optional.empty();
    }

    private static Optional<SyntaxToken> getPrecedingComma(VariableTree variable) {
        return QuickFixHelper.previousVariable(variable).map(Tree::lastToken);
    }
}

