/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import org.sonar.check.Rule;
import org.sonar.java.checks.tests.AbstractJUnit5NotCompliantModifierChecker;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S5810")
public class JUnit5SilentlyIgnoreClassAndMethodCheck
extends AbstractJUnit5NotCompliantModifierChecker {
    @Override
    protected boolean isNonCompliantModifier(Modifier modifier, boolean isMethod) {
        return modifier == Modifier.PRIVATE || isMethod && modifier == Modifier.STATIC;
    }

    @Override
    protected void raiseIssueOnNonCompliantReturnType(MethodTree methodTree) {
        boolean methodReturnAValue;
        TypeTree returnType = methodTree.returnType();
        Type type = returnType.symbolType();
        boolean bl = methodReturnAValue = !type.isUnknown() && !type.isVoid();
        if (methodReturnAValue && !methodTree.symbol().metadata().isAnnotatedWith("org.junit.jupiter.api.TestFactory")) {
            this.reportIssue(returnType, "Replace the return type by void.");
        }
    }
}

