/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5247")
public class DisableAutoEscapingCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure disabling auto-escaping feature is safe here.";
    private static final String MUSTACHE_ESCAPERS = "com.samskivert.mustache.Escapers";
    private static final String FREEMARKER_CONFIGURATION = "freemarker.template.Configuration";
    private static final MethodMatchers MUSTACHE_COMPILER_ESCAPE_HTML = MethodMatchers.create().ofTypes("com.samskivert.mustache.Mustache$Compiler").names("escapeHTML").addParametersMatcher("boolean").build();
    private static final MethodMatchers MUSTACHE_COMPILER_WITH_ESCAPER = MethodMatchers.create().ofTypes("com.samskivert.mustache.Mustache$Compiler").names("withEscaper").addParametersMatcher("com.samskivert.mustache.Mustache$Escaper").build();
    private static final MethodMatchers MUSTACHE_ESCAPERS_SIMPLE = MethodMatchers.create().ofTypes("com.samskivert.mustache.Escapers").names("simple").withAnyParameters().build();
    private static final MethodMatchers FREEMARKER_SET_AUTO_ESCAPING_POLICY = MethodMatchers.create().ofTypes("freemarker.template.Configuration").names("setAutoEscapingPolicy").addParametersMatcher("int").build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (FREEMARKER_SET_AUTO_ESCAPING_POLICY.matches(mit)) {
            this.handleFreeMarker(mit);
        } else {
            this.handleJMustache(mit);
        }
    }

    private void handleFreeMarker(MethodInvocationTree mit) {
        ExpressionTree policy = (ExpressionTree)mit.arguments().get(0);
        if (DisableAutoEscapingCheck.isFieldFromClassWithName(policy, FREEMARKER_CONFIGURATION, "DISABLE_AUTO_ESCAPING_POLICY")) {
            this.reportIssue(policy, MESSAGE);
        }
    }

    private void handleJMustache(MethodInvocationTree mit) {
        ExpressionTree argument;
        if (MUSTACHE_COMPILER_ESCAPE_HTML.matches(mit)) {
            ExpressionTree argument2 = (ExpressionTree)mit.arguments().get(0);
            argument2.asConstant(Boolean.class).filter(Boolean.FALSE::equals).ifPresent(cst -> this.reportIssue(argument2, MESSAGE));
        } else if (MUSTACHE_COMPILER_WITH_ESCAPER.matches(mit) && (DisableAutoEscapingCheck.isSimpleEscaper(argument = (ExpressionTree)mit.arguments().get(0)) || DisableAutoEscapingCheck.isFieldFromClassWithName(argument, MUSTACHE_ESCAPERS, "NONE"))) {
            this.reportIssue(argument, MESSAGE);
        }
    }

    private static boolean isSimpleEscaper(Tree tree) {
        if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            return mit.arguments().isEmpty() && MUSTACHE_ESCAPERS_SIMPLE.matches(mit);
        }
        return false;
    }

    private static boolean isFieldFromClassWithName(Tree tree, String classType, String name) {
        return DisableAutoEscapingCheck.extractIdentifier(tree).map(identifier -> DisableAutoEscapingCheck.checkOwner(identifier, classType, name)).orElse(false);
    }

    private static Optional<IdentifierTree> extractIdentifier(Tree tree) {
        if (tree.is(Tree.Kind.MEMBER_SELECT)) {
            return Optional.of(((MemberSelectExpressionTree)tree).identifier());
        }
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            return Optional.of((IdentifierTree)tree);
        }
        return Optional.empty();
    }

    private static boolean checkOwner(IdentifierTree identifier, String classType, String name) {
        Symbol owner = identifier.symbol().owner();
        return owner != null && owner.type().is(classType) && name.equals(identifier.name());
    }
}

