/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import javax.annotation.CheckForNull;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class DeprecatedCheckerHelper {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();

    private DeprecatedCheckerHelper() {
    }

    public static boolean hasJavadocDeprecatedTag(Tree tree) {
        return PublicApiChecker.getApiJavadoc(tree).filter(comment -> comment.contains("@deprecated")).isPresent();
    }

    @CheckForNull
    public static AnnotationTree deprecatedAnnotation(Tree tree) {
        AnnotationTree annotationTree = null;
        if (tree.is(CLASS_KINDS)) {
            annotationTree = DeprecatedCheckerHelper.deprecatedAnnotation((ClassTree)tree);
        } else if (tree.is(METHOD_KINDS)) {
            annotationTree = DeprecatedCheckerHelper.deprecatedAnnotation((MethodTree)tree);
        } else if (tree.is(Tree.Kind.VARIABLE)) {
            annotationTree = DeprecatedCheckerHelper.deprecatedAnnotation((VariableTree)tree);
        }
        return annotationTree;
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(ClassTree classTree) {
        return DeprecatedCheckerHelper.deprecatedAnnotation(classTree.modifiers().annotations());
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(VariableTree variableTree) {
        return DeprecatedCheckerHelper.deprecatedAnnotation(variableTree.modifiers().annotations());
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(MethodTree methodTree) {
        return DeprecatedCheckerHelper.deprecatedAnnotation(methodTree.modifiers().annotations());
    }

    @CheckForNull
    private static AnnotationTree deprecatedAnnotation(Iterable<AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            if (!DeprecatedCheckerHelper.isDeprecated(annotationTree)) continue;
            return annotationTree;
        }
        return null;
    }

    public static Tree reportTreeForDeprecatedTree(Tree tree) {
        Tree reportTree = tree;
        if (reportTree.is(PublicApiChecker.classKinds())) {
            reportTree = ExpressionsHelper.reportOnClassTree((ClassTree)reportTree);
        } else if (reportTree.is(PublicApiChecker.methodKinds())) {
            reportTree = ((MethodTree)reportTree).simpleName();
        } else if (reportTree.is(Tree.Kind.VARIABLE)) {
            reportTree = ((VariableTree)reportTree).simpleName();
        }
        return reportTree;
    }

    private static boolean isDeprecated(AnnotationTree tree) {
        return tree.annotationType().is(Tree.Kind.IDENTIFIER) && "Deprecated".equals(((IdentifierTree)tree.annotationType()).name());
    }
}

