/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2693")
public class ThreadStartedInConstructorCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers THREAD_START = MethodMatchers.create().ofSubTypes("java.lang.Thread").names("start").addWithoutParametersMatcher().build();
    private final Deque<Boolean> inMethodOrStaticInitializerOrFinalClass = new LinkedList<Boolean>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.RECORD, Tree.Kind.METHOD, Tree.Kind.METHOD_INVOCATION, Tree.Kind.STATIC_INITIALIZER);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.CLASS, Tree.Kind.RECORD)) {
            this.inMethodOrStaticInitializerOrFinalClass.push(((ClassTree)tree).symbol().isFinal());
        } else if (tree.is(Tree.Kind.METHOD, Tree.Kind.STATIC_INITIALIZER)) {
            this.inMethodOrStaticInitializerOrFinalClass.push(Boolean.TRUE);
        } else if (BooleanUtils.isFalse(this.inMethodOrStaticInitializerOrFinalClass.peek()) && THREAD_START.matches((MethodInvocationTree)tree)) {
            this.reportIssue(ExpressionUtils.methodName((MethodInvocationTree)tree), "Move this \"start\" call to another method.");
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.STATIC_INITIALIZER)) {
            this.inMethodOrStaticInitializerOrFinalClass.pop();
        }
    }
}

