/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2390")
public class SubClassStaticReferenceCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Type classType = classTree.symbol().type();
        List<Tree> members = classTree.members();
        this.checkStaticVariables(members, classType);
        this.checkStaticInitializers(members, classType);
    }

    private void checkStaticVariables(List<Tree> members, Type classType) {
        members.stream().filter(member -> member.is(Tree.Kind.VARIABLE)).map(VariableTree.class::cast).filter(SubClassStaticReferenceCheck::isStaticVariable).map(VariableTree::initializer).filter(Objects::nonNull).forEach(initializer -> initializer.accept(new StaticAccessVisitor(classType)));
    }

    private static boolean isStaticVariable(VariableTree tree) {
        return tree.symbol().isStatic();
    }

    private void checkStaticInitializers(List<Tree> members, Type classType) {
        members.stream().filter(member -> member.is(Tree.Kind.STATIC_INITIALIZER)).forEach(tree -> tree.accept(new StaticAccessVisitor(classType)));
    }

    private class StaticAccessVisitor
    extends BaseTreeVisitor {
        private final Type classTypeErasure;

        public StaticAccessVisitor(Type classType) {
            this.classTypeErasure = classType.erasure();
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.scan(tree.expression());
        }

        @Override
        public void visitClass(ClassTree tree) {
        }

        @Override
        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        @Override
        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            if (JavaKeyword.CLASS.getValue().equals(tree.identifier().name())) {
                return;
            }
            super.visitMemberSelectExpression(tree);
        }

        @Override
        public void visitIdentifier(IdentifierTree tree) {
            Type type = tree.symbolType();
            if (!this.sameErasure(type) && type.isSubtypeOf(this.classTypeErasure) && !this.isNestedSubtype(type)) {
                SubClassStaticReferenceCheck.this.reportIssue(tree, String.format("Remove this reference to \"%s\".", type.symbol().name()));
            }
        }

        private boolean sameErasure(Type type) {
            return this.classTypeErasure.equals(type.erasure());
        }

        private boolean isNestedSubtype(Type type) {
            Type ownerType = Objects.requireNonNull(type.symbol().owner()).type();
            return ownerType != null && ownerType.erasure().isSubtypeOf(this.classTypeErasure);
        }
    }
}

