/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_THRESHOLD = 3;
    private static final int MINIMAL_LITERAL_LENGTH = 7;
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;
    private final Map<String, List<LiteralTree>> occurrences = new HashMap<String, List<LiteralTree>>();
    private final Map<String, VariableTree> constants = new HashMap<String, VariableTree>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.occurrences.clear();
        this.constants.clear();
        this.scan(context.getTree());
        this.occurrences.forEach((key, literalTrees) -> {
            int literalOccurrence = literalTrees.size();
            if (this.constants.containsKey(key)) {
                VariableTree constant = this.constants.get(key);
                List duplications = literalTrees.stream().filter(literal -> literal.parent() != constant).collect(Collectors.toList());
                context.reportIssue(this, (Tree)duplications.iterator().next(), "Use already-defined constant '" + constant.simpleName() + "' instead of duplicating its value here.", StringLiteralDuplicatedCheck.secondaryLocations(duplications.subList(1, duplications.size())), literalOccurrence);
            } else if (literalOccurrence >= this.threshold) {
                LiteralTree literalTree = (LiteralTree)literalTrees.iterator().next();
                String message = literalTree.is(Tree.Kind.TEXT_BLOCK) ? "Define a constant instead of duplicating this text block " + literalOccurrence + " times." : "Define a constant instead of duplicating this literal \"" + key + "\" " + literalOccurrence + " times.";
                context.reportIssue(this, literalTree, message, StringLiteralDuplicatedCheck.secondaryLocations(literalTrees), literalOccurrence);
            }
        });
    }

    private static List<JavaFileScannerContext.Location> secondaryLocations(Collection<LiteralTree> literalTrees) {
        return literalTrees.stream().map(element -> new JavaFileScannerContext.Location("Duplication", (Tree)element)).collect(Collectors.toList());
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        String literal;
        if (tree.is(Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK) && (literal = tree.value()).length() >= 7) {
            String stringValue = LiteralUtils.getAsStringValue(tree).replace("\\n", "\n");
            this.occurrences.computeIfAbsent(stringValue, key -> new ArrayList()).add(tree);
        }
    }

    @Override
    public void visitVariable(VariableTree tree) {
        ExpressionTree initializer = tree.initializer();
        if (initializer != null && initializer.is(Tree.Kind.STRING_LITERAL, Tree.Kind.TEXT_BLOCK) && ModifiersUtils.hasModifier(tree.modifiers(), Modifier.STATIC) && ModifiersUtils.hasModifier(tree.modifiers(), Modifier.FINAL)) {
            String stringValue = LiteralUtils.getAsStringValue((LiteralTree)initializer).replace("\\n", "\n");
            this.constants.putIfAbsent(stringValue, tree);
            return;
        }
        super.visitVariable(tree);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        if (ModifiersUtils.hasModifier(tree.modifiers(), Modifier.DEFAULT)) {
            return;
        }
        super.visitMethod(tree);
    }

    @Override
    public void visitAnnotation(AnnotationTree annotationTree) {
    }
}

