/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2209")
public class StaticMembersAccessCheck
extends IssuableSubscriptionVisitor {
    private QuickFixHelper.ImportSupplier importSupplier;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.MEMBER_SELECT);
    }

    @Override
    public void setContext(JavaFileScannerContext context) {
        super.setContext(context);
        this.importSupplier = null;
    }

    @Override
    public void leaveFile(JavaFileScannerContext context) {
        this.importSupplier = null;
    }

    @Override
    public void visitNode(Tree tree) {
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)tree;
        IdentifierTree memberSelectIdentifier = memberSelect.identifier();
        Symbol memberSelectSymbol = memberSelectIdentifier.symbol();
        if (memberSelectSymbol.isStatic()) {
            ExpressionTree selectExpression;
            ExpressionTree leftOperand = memberSelect.expression();
            ExpressionTree expressionTree = selectExpression = leftOperand.is(Tree.Kind.MEMBER_SELECT) ? ((MemberSelectExpressionTree)leftOperand).identifier() : leftOperand;
            if (!selectExpression.is(Tree.Kind.IDENTIFIER) || ((IdentifierTree)selectExpression).symbol().isVariableSymbol()) {
                ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(leftOperand).withMessage("Change this instance-reference to a static reference.").withQuickFix(() -> this.createQuickFixes(leftOperand, memberSelectSymbol.owner().type()))).report();
            }
        }
    }

    private JavaQuickFix createQuickFixes(ExpressionTree leftOperand, Type type) {
        String leftOperandAsText = leftOperand.is(Tree.Kind.IDENTIFIER) ? "\"" + ((IdentifierTree)leftOperand).name() + "\"" : "the expression";
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix(String.format("Replace %s by \"%s\"", leftOperandAsText, type.name())).addTextEdit(JavaTextEdit.replaceTree(leftOperand, type.name()));
        if (this.importSupplier == null) {
            this.importSupplier = QuickFixHelper.newImportSupplier(this.context);
        }
        this.importSupplier.newImportEdit(type.fullyQualifiedName()).ifPresent(xva$0 -> builder.addTextEdit((JavaTextEdit)xva$0));
        return builder.build();
    }
}

