/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2226")
public class ServletInstanceFieldCheck
extends IssuableSubscriptionVisitor {
    private final List<VariableTree> issuableVariables = new ArrayList<VariableTree>();
    private final List<VariableTree> excludedVariables = new ArrayList<VariableTree>();
    private static final MethodMatchers INIT_METHOD_WITH_PARAM_MATCHER = MethodMatchers.create().ofSubTypes("javax.servlet.Servlet").names("init").addParametersMatcher("javax.servlet.ServletConfig").build();
    private static final MethodMatchers INIT_METHOD_NO_PARAMS_MATCHER = MethodMatchers.create().ofSubTypes("javax.servlet.GenericServlet").names("init").addWithoutParametersMatcher().build();
    private static final List<String> ANNOTATIONS_EXCLUDING_FIELDS = Arrays.asList("javax.inject.Inject", "javax.ejb.EJB", "org.springframework.beans.factory.annotation.Autowired", "javax.annotation.Resource");

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.VARIABLE, Tree.Kind.METHOD);
    }

    @Override
    public void leaveFile(JavaFileScannerContext context) {
        this.reportIssuesOnVariable();
    }

    @Override
    public void visitNode(Tree tree) {
        VariableTree variable;
        if (tree.is(Tree.Kind.METHOD) && ServletInstanceFieldCheck.isServletInit((MethodTree)tree)) {
            tree.accept(new AssignmentVisitor());
        } else if (tree.is(Tree.Kind.VARIABLE) && ServletInstanceFieldCheck.isOwnedByAServlet(variable = (VariableTree)tree) && !ServletInstanceFieldCheck.isExcluded(variable)) {
            this.issuableVariables.add(variable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExcluded(VariableTree variable) {
        SymbolMetadata varMetadata = variable.symbol().metadata();
        if (ServletInstanceFieldCheck.isStaticOrFinal(variable)) return true;
        if (!ANNOTATIONS_EXCLUDING_FIELDS.stream().anyMatch(varMetadata::isAnnotatedWith)) return false;
        return true;
    }

    private static boolean isServletInit(MethodTree tree) {
        return INIT_METHOD_WITH_PARAM_MATCHER.matches(tree) || INIT_METHOD_NO_PARAMS_MATCHER.matches(tree);
    }

    private void reportIssuesOnVariable() {
        this.issuableVariables.removeAll(this.excludedVariables);
        for (VariableTree variable : this.issuableVariables) {
            this.reportIssue(variable.simpleName(), "Remove this misleading mutable servlet instance field or make it \"static\" and/or \"final\"");
        }
        this.issuableVariables.clear();
        this.excludedVariables.clear();
    }

    private static boolean isOwnedByAServlet(VariableTree variable) {
        Symbol owner = variable.symbol().owner();
        return owner.isTypeSymbol() && variable.parent().is(Tree.Kind.CLASS) && (owner.type().isSubtypeOf("javax.servlet.http.HttpServlet") || owner.type().isSubtypeOf("org.apache.struts.action.Action"));
    }

    private static boolean isStaticOrFinal(VariableTree variable) {
        ModifiersTree modifiers = variable.modifiers();
        return ModifiersUtils.hasModifier(modifiers, Modifier.STATIC) || ModifiersUtils.hasModifier(modifiers, Modifier.FINAL);
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private AssignmentVisitor() {
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            Tree declaration;
            if (tree.variable().is(Tree.Kind.IDENTIFIER) && (declaration = ((IdentifierTree)tree.variable()).symbol().declaration()) != null && declaration.is(Tree.Kind.VARIABLE)) {
                ServletInstanceFieldCheck.this.excludedVariables.add((VariableTree)declaration);
            }
        }
    }
}

