/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1161")
public class OverrideAnnotationCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        if (OverrideAnnotationCheck.isExcludedByVersion(this.context.getJavaVersion())) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        List<Symbol.MethodSymbol> overriddenSymbols = methodSymbol.overriddenSymbols();
        if (overriddenSymbols.isEmpty()) {
            return;
        }
        Symbol.MethodSymbol overriddenSymbol = overriddenSymbols.get(0);
        if (!(overriddenSymbol.isAbstract() || OverrideAnnotationCheck.isObjectMethod(overriddenSymbol) || OverrideAnnotationCheck.isAnnotatedOverride(methodSymbol))) {
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(methodTree.simpleName()).withMessage("Add the \"@Override\" annotation above this method signature").withQuickFix(() -> this.quickFix(methodTree))).report();
        }
    }

    private static boolean isExcludedByVersion(JavaVersion javaVersion) {
        if (javaVersion.isNotSet()) {
            return false;
        }
        return javaVersion.asInt() <= 4;
    }

    private static boolean isObjectMethod(Symbol.MethodSymbol method) {
        return method.owner().type().is("java.lang.Object");
    }

    private static boolean isAnnotatedOverride(Symbol.MethodSymbol method) {
        return method.metadata().isAnnotatedWith("java.lang.Override");
    }

    private JavaQuickFix quickFix(MethodTree methodTree) {
        ModifiersTree modifiersTree = methodTree.modifiers();
        SyntaxToken targetTree = modifiersTree.isEmpty() ? QuickFixHelper.nextToken(modifiersTree) : (Tree)modifiersTree.get(0);
        Object insertedText = OverrideAnnotationCheck.somethingBeforeOnSameLine(methodTree) ? "@Override " : "@Override\n" + this.padding(targetTree);
        return JavaQuickFix.newQuickFix("Add \"@Override\" annotation").addTextEdit(JavaTextEdit.insertBeforeTree(targetTree, (String)insertedText)).build();
    }

    private static boolean somethingBeforeOnSameLine(Tree tree) {
        return QuickFixHelper.previousToken(tree).range().start().line() == tree.firstToken().range().start().line();
    }

    private String padding(Tree tree) {
        Position start = tree.firstToken().range().start();
        return this.context.getFileLines().get(start.lineOffset()).substring(0, start.columnOffset());
    }
}

