/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S6217")
public class OmitPermittedTypesCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Remove this redundant permitted list.";
    private final List<ClassTree> sealedClassesInFile = new ArrayList<ClassTree>();
    private final Set<Type> typesDeclaredInFile = new HashSet<Type>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.permitsKeyword() != null) {
            this.sealedClassesInFile.add(classTree);
        }
        this.typesDeclaredInFile.add(classTree.symbol().type());
    }

    @Override
    public void leaveFile(JavaFileScannerContext context) {
        for (ClassTree sealedClass : this.sealedClassesInFile) {
            ListTree<TypeTree> permittedTypes = sealedClass.permittedTypes();
            if (!permittedTypes.stream().map(TypeTree::symbolType).allMatch(this.typesDeclaredInFile::contains)) continue;
            SyntaxToken permitsKeyword = sealedClass.permitsKeyword();
            ((InternalJavaIssueBuilder)((InternalJavaIssueBuilder)QuickFixHelper.newIssue(context).forRule(this).onTree(permitsKeyword).withMessage(MESSAGE).withSecondaries(permittedTypes.stream().map(t -> new JavaFileScannerContext.Location("Permitted type", (Tree)t)).collect(Collectors.toList()))).withQuickFix(() -> OmitPermittedTypesCheck.getQuickFix(permitsKeyword, permittedTypes))).report();
        }
        this.sealedClassesInFile.clear();
        this.typesDeclaredInFile.clear();
        super.leaveFile(context);
    }

    private static JavaQuickFix getQuickFix(SyntaxToken permitsKeyword, ListTree<TypeTree> typeTrees) {
        return JavaQuickFix.newQuickFix("Remove permitted list").addTextEdit(JavaTextEdit.removeTextSpan(AnalyzerMessage.textSpanBetween(permitsKeyword, true, QuickFixHelper.nextToken(typeTrees), false))).build();
    }
}

