/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2384")
public class MutableMembersUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final List<String> MUTABLE_TYPES = Arrays.asList("java.util.Collection", "java.util.Date", "java.util.Hashtable");
    private static final List<String> IMMUTABLE_TYPES = Arrays.asList("java.util.Collections.UnmodifiableCollection", "java.util.Collections.UnmodifiableMap", "com.google.common.collect.ImmutableCollection");
    private static final MethodMatchers UNMODIFIABLE_COLLECTION_CALL = MethodMatchers.or(MethodMatchers.create().ofType(type -> MutableMembersUsageCheck.containsImmutableLikeTerm(type.name())).anyName().withAnyParameters().build(), MethodMatchers.create().ofAnyType().name(MutableMembersUsageCheck::containsImmutableLikeTerm).withAnyParameters().build(), MethodMatchers.create().ofTypes("java.util.Collections").name(name -> name.startsWith("singleton") || name.startsWith("empty")).withAnyParameters().build(), MethodMatchers.create().ofTypes("java.util.Set", "java.util.List").names("of", "copyOf").withAnyParameters().build());
    private JavaFileScannerContext context;
    private Deque<Set<Symbol>> parametersStack = new LinkedList<Set<Symbol>>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        Symbol.TypeSymbol enclosingClass;
        if (tree.is(Tree.Kind.CONSTRUCTOR) && (enclosingClass = tree.symbol().enclosingClass()).isEnum()) {
            return;
        }
        this.parametersStack.push(tree.parameters().stream().map(VariableTree::symbol).collect(Collectors.toSet()));
        super.visitMethod(tree);
        this.parametersStack.pop();
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        if (!MutableMembersUsageCheck.isMutableType(tree.expression())) {
            return;
        }
        ExpressionTree variable = tree.variable();
        Symbol leftSymbol = null;
        if (variable.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree identifierTree = (IdentifierTree)variable;
            leftSymbol = identifierTree.symbol();
        } else if (variable.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mit = (MemberSelectExpressionTree)variable;
            leftSymbol = mit.identifier().symbol();
        }
        if (leftSymbol != null && leftSymbol.isPrivate()) {
            this.checkStore(tree.expression());
        }
    }

    private void checkStore(ExpressionTree expression) {
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree identifierTree = (IdentifierTree)expression;
            if (!this.parametersStack.isEmpty() && this.parametersStack.peek().contains(identifierTree.symbol())) {
                this.context.reportIssue(this, identifierTree, "Store a copy of \"" + identifierTree.name() + "\".");
            }
        }
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        ExpressionTree expressionTree = tree.expression();
        if (expressionTree == null || !MutableMembersUsageCheck.isMutableType(expressionTree)) {
            return;
        }
        this.checkReturnedExpression(expressionTree);
    }

    private void checkReturnedExpression(ExpressionTree expression) {
        IdentifierTree identifierTree;
        MemberSelectExpressionTree mse;
        if (expression.is(Tree.Kind.MEMBER_SELECT) && MutableMembersUsageCheck.isThis((mse = (MemberSelectExpressionTree)expression).expression())) {
            this.checkReturnedExpression(mse.identifier());
        }
        if (expression.is(Tree.Kind.IDENTIFIER) && (identifierTree = (IdentifierTree)expression).symbol().isPrivate() && !MutableMembersUsageCheck.isOnlyAssignedImmutableVariable((Symbol.VariableSymbol)identifierTree.symbol())) {
            this.context.reportIssue(this, identifierTree, "Return a copy of \"" + identifierTree.name() + "\".");
        }
    }

    private static boolean isThis(ExpressionTree expression) {
        return expression.is(Tree.Kind.IDENTIFIER) && ((IdentifierTree)expression).name().equals("this");
    }

    private static boolean isOnlyAssignedImmutableVariable(Symbol.VariableSymbol symbol) {
        ExpressionTree initializer;
        VariableTree declaration = symbol.declaration();
        if (declaration != null && (initializer = declaration.initializer()) != null) {
            boolean isInitializerImmutable;
            boolean bl = isInitializerImmutable = !MutableMembersUsageCheck.isMutableType(initializer) || MutableMembersUsageCheck.isEmptyArray(initializer);
            if (symbol.isFinal() || !isInitializerImmutable) {
                return isInitializerImmutable;
            }
        }
        return !MutableMembersUsageCheck.assignementsOfMutableType(symbol.usages());
    }

    private static boolean isEmptyArray(ExpressionTree initializer) {
        return initializer.is(Tree.Kind.NEW_ARRAY) && !((NewArrayTree)initializer).dimensions().isEmpty() && ((NewArrayTree)initializer).dimensions().stream().allMatch(adt -> MutableMembersUsageCheck.isZeroLiteralValue(adt.expression()));
    }

    private static boolean isZeroLiteralValue(@Nullable ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return false;
        }
        Integer integer = LiteralUtils.intLiteralValue(expressionTree);
        return integer != null && integer == 0;
    }

    private static boolean assignementsOfMutableType(List<IdentifierTree> usages) {
        for (IdentifierTree usage : usages) {
            AssignmentExpressionTree assignment;
            Tree current = usage;
            Tree parent = usage.parent();
            while (!parent.is(Tree.Kind.ASSIGNMENT) && (parent = (current = parent).parent()) != null) {
            }
            if (parent == null || !(assignment = (AssignmentExpressionTree)parent).variable().equals(current) || !MutableMembersUsageCheck.isMutableType(assignment.expression())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMutableType(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.NULL_LITERAL)) {
            return false;
        }
        if (expressionTree.is(Tree.Kind.METHOD_INVOCATION) && UNMODIFIABLE_COLLECTION_CALL.matches((MethodInvocationTree)expressionTree)) {
            return false;
        }
        return MutableMembersUsageCheck.isMutableType(expressionTree.symbolType());
    }

    private static boolean isMutableType(Type type) {
        if (type.isArray()) {
            return true;
        }
        for (String mutableType : MUTABLE_TYPES) {
            if (!type.isSubtypeOf(mutableType) || !MutableMembersUsageCheck.isNotImmutable(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotImmutable(Type type) {
        for (String immutableType : IMMUTABLE_TYPES) {
            if (!type.isSubtypeOf(immutableType)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsImmutableLikeTerm(String methodName) {
        String lowerCaseName = methodName.toLowerCase(Locale.ROOT);
        return lowerCaseName.contains("unmodifiable") || lowerCaseName.contains("immutable");
    }
}

