/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@DeprecatedRuleKey(ruleKey="IndentationCheck", repositoryKey="squid")
@Rule(key="S1120")
public class IndentationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_INDENTATION_LEVEL = 2;
    @RuleProperty(key="indentationLevel", description="Number of white-spaces of an indent.", defaultValue="2")
    public int indentationLevel = 2;
    private int expectedLevel;
    private boolean isBlockAlreadyReported;
    private int excludeIssueAtLine;
    private JavaFileScannerContext context;
    private List<String> fileLines;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.expectedLevel = 0;
        this.isBlockAlreadyReported = false;
        this.excludeIssueAtLine = 0;
        this.context = context;
        this.fileLines = context.getFileLines();
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        boolean isAnonymous;
        boolean bl = isAnonymous = tree.simpleName() == null;
        if (!isAnonymous) {
            this.checkIndentation(Collections.singletonList(tree));
        }
        int previousLevel = this.expectedLevel;
        if (isAnonymous) {
            this.excludeIssueAtLine = tree.openBraceToken().range().start().line();
            this.expectedLevel = tree.closeBraceToken().range().start().columnOffset();
        }
        this.newBlock();
        this.checkIndentation(tree.members());
        super.visitClass(tree);
        this.leaveNode(tree);
        this.expectedLevel = previousLevel;
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.newBlock();
        this.adjustBlockForExceptionalParents(tree.parent());
        this.checkIndentation(tree.body());
        super.visitBlock(tree);
        this.restoreBlockForExceptionalParents(tree.parent());
        this.leaveNode(tree);
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.newBlock();
        this.scan(tree.expression());
        for (CaseGroupTree caseGroupTree : tree.cases()) {
            this.newBlock();
            this.checkCaseGroup(caseGroupTree);
            this.scan(caseGroupTree);
            this.leaveNode(caseGroupTree);
        }
        this.leaveNode(tree);
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        Tree body = lambdaExpressionTree.body();
        if (body.is(Tree.Kind.BLOCK)) {
            BlockTree block = (BlockTree)body;
            this.excludeIssueAtLine = block.openBraceToken().range().start().line();
            int previousLevel = this.expectedLevel;
            this.expectedLevel = block.closeBraceToken().range().start().columnOffset();
            this.scan(block);
            this.expectedLevel = previousLevel;
        } else {
            this.scan(body);
        }
    }

    private void newBlock() {
        this.expectedLevel += this.indentationLevel;
        this.isBlockAlreadyReported = false;
    }

    private void leaveNode(Tree tree) {
        this.expectedLevel -= this.indentationLevel;
        this.isBlockAlreadyReported = false;
        this.excludeIssueAtLine = tree.lastToken().range().start().line();
    }

    private void checkCaseGroup(CaseGroupTree tree) {
        List<StatementTree> body;
        List<CaseLabelTree> labels = tree.labels();
        if (labels.size() >= 2) {
            CaseLabelTree previousCaseLabelTree = labels.get(labels.size() - 2);
            this.excludeIssueAtLine = previousCaseLabelTree.lastToken().range().start().line();
        }
        List<StatementTree> newBody = body = tree.body();
        int bodySize = body.size();
        if (bodySize > 0 && body.get(0).is(Tree.Kind.BLOCK)) {
            this.expectedLevel -= this.indentationLevel;
            this.checkIndentation(body.get(0), ListUtils.getLast(labels).colonOrArrowToken().range().start().columnOffset() + 2);
            newBody = body.subList(1, bodySize);
        }
        this.checkIndentation(newBody);
        if (bodySize > 0 && body.get(0).is(Tree.Kind.BLOCK)) {
            this.expectedLevel += this.indentationLevel;
        }
    }

    private void adjustBlockForExceptionalParents(Tree parent) {
        if (parent.is(Tree.Kind.CASE_GROUP)) {
            this.expectedLevel -= this.indentationLevel;
        }
    }

    private void restoreBlockForExceptionalParents(Tree parent) {
        if (parent.is(Tree.Kind.CASE_GROUP)) {
            this.expectedLevel += this.indentationLevel;
        }
    }

    private void checkIndentation(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            this.checkIndentation(tree, this.expectedLevel);
        }
    }

    private void checkIndentation(Tree tree, int expectedLevel) {
        Position treeStart = tree.firstToken().range().start();
        String line = this.fileLines.get(treeStart.lineOffset());
        int level = treeStart.columnOffset();
        int indentLength = Math.min(treeStart.columnOffset(), line.length());
        for (int i = 0; i < indentLength; ++i) {
            if (line.charAt(i) != '\t') continue;
            level += this.indentationLevel - 1;
        }
        if (level != expectedLevel && !this.isExcluded(tree, treeStart.line())) {
            this.context.addIssue(((JavaTree)tree).getLine(), this, "Make this line start after " + expectedLevel + " spaces to indent the code consistently.");
            this.isBlockAlreadyReported = true;
        }
        this.excludeIssueAtLine = tree.lastToken().range().start().line();
    }

    private boolean isExcluded(Tree node, int nodeLine) {
        return this.excludeIssueAtLine == nodeLine || this.isBlockAlreadyReported || node.is(Tree.Kind.ENUM_CONSTANT);
    }
}

