/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S899")
public class IgnoredOperationStatusCheck
extends AbstractMethodDetection {
    private static final String FILE = "java.io.File";
    private static final String CONDITION = "java.util.concurrent.locks.Condition";
    private static final String BLOCKING_QUEUE = "java.util.concurrent.BlockingQueue";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.util.concurrent.locks.Lock").names("tryLock").addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(FILE).name(name -> name.equals("delete") || name.equals("exists") || name.equals("createNewFile") || name.startsWith("can") || name.startsWith("is")).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes(FILE).name(name -> name.startsWith("set")).withAnyParameters().build(), MethodMatchers.create().ofTypes(FILE).names("renameTo").addParametersMatcher(FILE).build(), MethodMatchers.create().ofSubTypes("java.util.Iterator").names("hasNext").addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes("java.util.Enumeration").names("hasMoreElements").addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes(CONDITION).names("await").addParametersMatcher("long", "java.util.concurrent.TimeUnit").build(), MethodMatchers.create().ofSubTypes(CONDITION).names("awaitUntil").addParametersMatcher("java.util.Date").build(), MethodMatchers.create().ofSubTypes(CONDITION).names("awaitNanos").addParametersMatcher("long").build(), MethodMatchers.create().ofTypes("java.util.concurrent.CountDownLatch").names("await").addParametersMatcher("long", "java.util.concurrent.TimeUnit").build(), MethodMatchers.create().ofTypes("java.util.concurrent.Semaphore").names("tryAcquire").withAnyParameters().build(), MethodMatchers.create().ofSubTypes(BLOCKING_QUEUE).names("offer").withAnyParameters().build(), MethodMatchers.create().ofSubTypes(BLOCKING_QUEUE).names("remove").withAnyParameters().build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent.is(Tree.Kind.EXPRESSION_STATEMENT) || parent.is(Tree.Kind.VARIABLE) && ((VariableTree)parent).symbol().usages().isEmpty()) {
            this.reportIssue(parent, "Do something with the \"" + mit.symbolType().name() + "\" value returned by \"" + mit.symbol().name() + "\".");
        }
    }
}

