/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

@Rule(key="S3725")
public class FilesExistsJDK8Check
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String JAVA_NIO_FILE_FILES = "java.nio.file.Files";
    private static final String EXISTS = "exists";
    private static final String IS_DIRECTORY = "isDirectory";
    private static final Map<String, String> messageParam = MapBuilder.newMap().put("exists", "exists").put("notExists", "exists").put("isRegularFile", "isFile").put("isDirectory", "isDirectory").build();

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.asInt() == 8;
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(JAVA_NIO_FILE_FILES).names(EXISTS, "notExists", "isRegularFile", IS_DIRECTORY).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        this.reportIssue(ExpressionUtils.methodName(mit), "Replace this with a call to the \"toFile()." + messageParam.get(methodName) + "()\" method");
    }

    @Override
    protected void onMethodReferenceFound(MethodReferenceTree methodReferenceTree) {
        String methodName = methodReferenceTree.method().symbol().name();
        this.reportIssue(methodReferenceTree.method(), "Replace this with a call to the \"toFile()." + messageParam.get(methodName) + "()\" method");
    }
}

