/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2039")
public class FieldModifierCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        classTree.members().stream().filter(FieldModifierCheck::isConsentWithCheck).forEach(member -> {
            IdentifierTree simpleName = ((VariableTree)member).simpleName();
            this.reportIssue(simpleName, "Explicitly declare the visibility for \"" + simpleName.name() + "\".");
        });
    }

    private static boolean isConsentWithCheck(Tree member) {
        return member.is(Tree.Kind.VARIABLE) && FieldModifierCheck.hasNoVisibilityModifier((VariableTree)member) && !FieldModifierCheck.isVisibleForTesting((VariableTree)member);
    }

    private static boolean hasNoVisibilityModifier(VariableTree variableTree) {
        ModifiersTree modifiers = variableTree.modifiers();
        return !ModifiersUtils.hasModifier(modifiers, Modifier.PUBLIC) && !ModifiersUtils.hasModifier(modifiers, Modifier.PRIVATE) && !ModifiersUtils.hasModifier(modifiers, Modifier.PROTECTED);
    }

    private static boolean isVisibleForTesting(VariableTree variableTree) {
        return variableTree.modifiers().annotations().stream().anyMatch(annotation -> "VisibleForTesting".equals(annotation.annotationType().lastToken().text()));
    }
}

