/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2293")
public class DiamondOperatorCheck
extends SubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final Tree.Kind[] JAVA_7_KINDS = new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.TYPE_CAST, Tree.Kind.RETURN_STATEMENT, Tree.Kind.ASSIGNMENT};
    private static final Tree.Kind[] JAVA_8_KINDS = (Tree.Kind[])ArrayUtils.addAll(JAVA_7_KINDS, new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION});
    private Tree.Kind[] expressionKindsToCheck = JAVA_7_KINDS;

    @Override
    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        if (version.isJava8Compatible()) {
            this.expressionKindsToCheck = JAVA_8_KINDS;
        }
        return version.isJava7Compatible();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        NewClassTree newClassTree = (NewClassTree)tree;
        TypeTree newTypeTree = newClassTree.identifier();
        if (!DiamondOperatorCheck.isParameterizedType(newTypeTree) || newClassTree.classBody() != null) {
            return;
        }
        TypeTree type = DiamondOperatorCheck.getTypeFromExpression(tree.parent(), this.expressionKindsToCheck);
        if (type != null && DiamondOperatorCheck.isParameterizedType(type) || DiamondOperatorCheck.usedAsArgumentWithoutDiamond(newClassTree)) {
            TypeArguments typeArguments = ((ParameterizedTypeTree)newTypeTree).typeArguments();
            ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(typeArguments).withMessage("Replace the type specification in this constructor call with the diamond operator (\"<>\").%s", this.context.getJavaVersion().java7CompatibilityMessage()).withQuickFix(() -> JavaQuickFix.newQuickFix("Replace with <>").addTextEdit(JavaTextEdit.replaceTree(typeArguments, "<>")).build())).report();
        }
    }

    private static boolean usedAsArgumentWithoutDiamond(NewClassTree newClassTree) {
        Tree parent = newClassTree.parent();
        if (!parent.is(Tree.Kind.ARGUMENTS)) {
            return false;
        }
        Tree invocation = parent.parent();
        Symbol symbol = null;
        symbol = invocation.is(Tree.Kind.METHOD_INVOCATION) ? ((MethodInvocationTree)invocation).symbol() : ((NewClassTree)invocation).constructorSymbol();
        if (!symbol.isMethodSymbol()) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        int index = DiamondOperatorCheck.getArgIndex(newClassTree, (Arguments)parent);
        if (index >= methodSymbol.parameterTypes().size()) {
            return false;
        }
        if (JUtils.isParametrizedMethod(methodSymbol)) {
            return false;
        }
        Type parameterType = methodSymbol.parameterTypes().get(index);
        return parameterType.isParameterized();
    }

    private static int getArgIndex(Tree tree, Arguments arguments) {
        int i = 0;
        while (!tree.equals(arguments.get(i))) {
            ++i;
        }
        return i;
    }

    @CheckForNull
    private static TypeTree getTypeFromExpression(Tree expression, Tree.Kind[] kinds) {
        if (expression.is(kinds)) {
            TypeTreeLocator visitor = new TypeTreeLocator(kinds);
            expression.accept(visitor);
            return visitor.type;
        }
        return null;
    }

    private static boolean isParameterizedType(TypeTree type) {
        if (type.is(Tree.Kind.ARRAY_TYPE)) {
            return DiamondOperatorCheck.isParameterizedType(((ArrayTypeTree)type).type());
        }
        return type.is(Tree.Kind.PARAMETERIZED_TYPE) && !((ParameterizedTypeTree)type).typeArguments().isEmpty();
    }

    private static class TypeTreeLocator
    extends BaseTreeVisitor {
        private final Tree.Kind[] kinds;
        @Nullable
        private TypeTree type = null;

        public TypeTreeLocator(Tree.Kind[] kinds) {
            this.kinds = kinds;
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            this.type = TypeTreeLocator.getMethodReturnType(tree);
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            this.type = tree.type();
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            Tree assignedVariable = TypeTreeLocator.getAssignedVariable(tree.variable());
            if (assignedVariable != null) {
                this.type = DiamondOperatorCheck.getTypeFromExpression(assignedVariable, this.kinds);
            }
        }

        @Override
        public void visitVariable(VariableTree tree) {
            this.type = tree.type();
        }

        @Override
        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            this.type = DiamondOperatorCheck.getTypeFromExpression(tree.parent(), this.kinds);
        }

        @CheckForNull
        private static TypeTree getMethodReturnType(ReturnStatementTree returnStatementTree) {
            MethodTree methodTree = TypeTreeLocator.getParentMethod(returnStatementTree);
            if (methodTree != null) {
                return methodTree.returnType();
            }
            return null;
        }

        @CheckForNull
        private static MethodTree getParentMethod(Tree tree) {
            Tree result;
            for (result = tree; result != null && !result.is(Tree.Kind.METHOD); result = result.parent()) {
            }
            return (MethodTree)result;
        }

        @CheckForNull
        private static Tree getAssignedVariable(ExpressionTree expression) {
            IdentifierTree identifier;
            switch (expression.kind()) {
                case ARRAY_ACCESS_EXPRESSION: {
                    return TypeTreeLocator.getAssignedVariable(((ArrayAccessExpressionTree)expression).expression());
                }
                case TYPE_CAST: {
                    return TypeTreeLocator.getAssignedVariable(((TypeCastTree)expression).expression());
                }
                case PARENTHESIZED_EXPRESSION: {
                    return TypeTreeLocator.getAssignedVariable(((ParenthesizedTree)expression).expression());
                }
                case IDENTIFIER: {
                    identifier = (IdentifierTree)expression;
                    break;
                }
                case MEMBER_SELECT: {
                    identifier = ((MemberSelectExpressionTree)expression).identifier();
                    break;
                }
                case METHOD_INVOCATION: {
                    return TypeTreeLocator.getAssignedVariable(((MethodInvocationTree)expression).methodSelect());
                }
                default: {
                    throw new IllegalStateException("Unexpected expression " + expression.kind().name() + " at: " + ((JavaTree)((Object)expression)).getLine());
                }
            }
            return identifier.symbol().declaration();
        }
    }
}

