/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.IllegalRuleParameterException;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S124")
public class CommentRegularExpressionCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_REGULAR_EXPRESSION = "";
    private static final String DEFAULT_MESSAGE = "The regular expression matches this comment.";
    @Nullable
    private Pattern pattern = null;
    @RuleProperty(key="regularExpression", description="The regular expression", defaultValue="")
    public String regularExpression = "";
    @RuleProperty(key="message", description="The issue message", defaultValue="The regular expression matches this comment.")
    public String message = "The regular expression matches this comment.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRIVIA);
    }

    @Override
    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        if (this.pattern == null && !CommentRegularExpressionCheck.isNullOrEmpty(this.regularExpression)) {
            try {
                this.pattern = Pattern.compile(this.regularExpression, 32);
            }
            catch (RuntimeException e) {
                throw new IllegalRuleParameterException("Unable to compile regular expression: " + this.regularExpression, e);
            }
        }
        if (this.pattern != null && this.pattern.matcher(syntaxTrivia.comment()).matches()) {
            this.addIssue(syntaxTrivia.range().start().line(), this.message);
        }
    }

    private static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }
}

