/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.InternalJavaIssueBuilder;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1155")
public class CollectionIsEmptyCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final MethodMatchers SIZE_METHOD = MethodMatchers.create().ofSubTypes("java.util.Collection").names("size").addWithoutParametersMatcher().build();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (tree.symbol().type().isSubtypeOf(JAVA_UTIL_COLLECTION) && member.is(Tree.Kind.METHOD)) continue;
            this.scan(member);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        CollectionIsEmptyCheck.getCallToSizeInvocation(tree).ifPresent(callToSizeInvocation -> CollectionIsEmptyCheck.getEmptyComparisonType(tree).ifPresent(comparisonType -> ((InternalJavaIssueBuilder)QuickFixHelper.newIssue(this.context).forRule(this).onTree(tree).withMessage("Use isEmpty() to check whether the collection is empty or not.").withQuickFix(() -> CollectionIsEmptyCheck.getQuickFix(tree, callToSizeInvocation, comparisonType))).report()));
    }

    private static JavaQuickFix getQuickFix(BinaryExpressionTree tree, MethodInvocationTree callToSizeInvocation, EmptyComparisonType emptyComparisonType) {
        String replacement;
        IdentifierTree sizeCallIdentifier = ExpressionUtils.methodName(callToSizeInvocation);
        JavaQuickFix.Builder builder = JavaQuickFix.newQuickFix("Use \"isEmpty()\"");
        AnalyzerMessage.TextSpan textSpan = AnalyzerMessage.textSpanBetween(tree.firstToken(), true, callToSizeInvocation, false);
        String string = replacement = emptyComparisonType == EmptyComparisonType.EMPTY ? "" : "!";
        if (!textSpan.isEmpty() || !replacement.isEmpty()) {
            builder.addTextEdit(JavaTextEdit.replaceTextSpan(textSpan, replacement));
        }
        builder.addTextEdit(JavaTextEdit.replaceTextSpan(AnalyzerMessage.textSpanBetween(sizeCallIdentifier, true, tree.lastToken(), true), "isEmpty()"));
        return builder.build();
    }

    private static Optional<MethodInvocationTree> getCallToSizeInvocation(BinaryExpressionTree tree) {
        Optional<MethodInvocationTree> leftCallToSize = CollectionIsEmptyCheck.getCallToSizeInvocation(tree.leftOperand());
        if (leftCallToSize.isPresent()) {
            return leftCallToSize;
        }
        return CollectionIsEmptyCheck.getCallToSizeInvocation(tree.rightOperand());
    }

    private static Optional<MethodInvocationTree> getCallToSizeInvocation(ExpressionTree tree) {
        MethodInvocationTree invocationTree;
        if (tree.is(Tree.Kind.METHOD_INVOCATION) && SIZE_METHOD.matches(invocationTree = (MethodInvocationTree)tree)) {
            return Optional.of(invocationTree);
        }
        return Optional.empty();
    }

    private static Optional<EmptyComparisonType> getEmptyComparisonType(BinaryExpressionTree tree) {
        boolean anyZero;
        boolean leftIsZero = LiteralUtils.isZero(tree.leftOperand());
        boolean leftIsOne = LiteralUtils.isOne(tree.leftOperand());
        boolean rightIsZero = LiteralUtils.isZero(tree.rightOperand());
        boolean rightIsOne = LiteralUtils.isOne(tree.rightOperand());
        boolean bl = anyZero = leftIsZero || rightIsZero;
        if (CollectionIsEmptyCheck.isEmptyComparison(tree, leftIsZero, leftIsOne, rightIsZero, rightIsOne, anyZero)) {
            return Optional.of(EmptyComparisonType.EMPTY);
        }
        if (CollectionIsEmptyCheck.isNotEmptyComparison(tree, leftIsZero, leftIsOne, rightIsZero, rightIsOne, anyZero)) {
            return Optional.of(EmptyComparisonType.NOT_EMPTY);
        }
        return Optional.empty();
    }

    private static boolean isEmptyComparison(BinaryExpressionTree tree, boolean leftIsZero, boolean leftIsOne, boolean rightIsZero, boolean rightIsOne, boolean anyZero) {
        return tree.is(Tree.Kind.EQUAL_TO) && anyZero || tree.is(Tree.Kind.LESS_THAN) && rightIsOne || tree.is(Tree.Kind.LESS_THAN_OR_EQUAL_TO) && rightIsZero || tree.is(Tree.Kind.GREATER_THAN) && leftIsOne || tree.is(Tree.Kind.GREATER_THAN_OR_EQUAL_TO) && leftIsZero;
    }

    private static boolean isNotEmptyComparison(BinaryExpressionTree tree, boolean leftIsZero, boolean leftIsOne, boolean rightIsZero, boolean rightIsOne, boolean anyZero) {
        return tree.is(Tree.Kind.NOT_EQUAL_TO) && anyZero || tree.is(Tree.Kind.GREATER_THAN) && rightIsZero || tree.is(Tree.Kind.GREATER_THAN_OR_EQUAL_TO) && rightIsOne || tree.is(Tree.Kind.LESS_THAN) && leftIsZero || tree.is(Tree.Kind.LESS_THAN_OR_EQUAL_TO) && leftIsOne;
    }

    private static enum EmptyComparisonType {
        EMPTY,
        NOT_EMPTY;

    }
}

