/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1182")
public class CloneMethodCallsSuperCloneCheck
extends IssuableSubscriptionVisitor {
    private boolean foundSuperClone;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        if (CloneMethodCallsSuperCloneCheck.isCloneMethod(tree)) {
            this.foundSuperClone = false;
        } else if (CloneMethodCallsSuperCloneCheck.isSuperCloneCall(tree)) {
            this.foundSuperClone = true;
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (CloneMethodCallsSuperCloneCheck.isCloneMethod(tree) && !this.foundSuperClone) {
            this.reportIssue(((MethodTree)tree).simpleName(), "Use super.clone() to create and seed the cloned instance to be returned.");
        }
    }

    private static boolean isCloneMethod(Tree tree) {
        if (!tree.is(Tree.Kind.METHOD)) {
            return false;
        }
        MethodTree methodTree = (MethodTree)tree;
        return "clone".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && methodTree.block() != null;
    }

    private static boolean isSuperCloneCall(Tree tree) {
        if (!tree.is(Tree.Kind.METHOD_INVOCATION)) {
            return false;
        }
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        return mit.arguments().isEmpty() && mit.methodSelect().is(Tree.Kind.MEMBER_SELECT) && CloneMethodCallsSuperCloneCheck.isSuperClone((MemberSelectExpressionTree)mit.methodSelect());
    }

    private static boolean isSuperClone(MemberSelectExpressionTree tree) {
        return "clone".equals(tree.identifier().name()) && tree.expression().is(Tree.Kind.IDENTIFIER) && "super".equals(((IdentifierTree)tree.expression()).name());
    }
}

